/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.replication.RecoverStandbyProcedure;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestRegisterPeerWorkerWhenRestarting
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegisterPeerWorkerWhenRestarting.class);
    private static volatile boolean FAIL = false;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL2.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        SyncReplicationTestBase.setUp();
    }

    @Test
    public void testRestart() throws Exception {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 100);
        Thread.sleep(2000L);
        this.verifyNotReplicatedThroughRegion(UTIL2, 0, 100);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        HMaster master = UTIL2.getHBaseCluster().getMaster();
        FAIL = true;
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        t.start();
        UTIL2.waitFor(60000L, () -> procExec.getProcedures().stream().filter(p -> p instanceof RecoverStandbyProcedure).map(p -> (RecoverStandbyProcedure)p).anyMatch(p -> p.getCurrentStateId() == 3 || p.getCurrentStateId() == 4));
        JVMClusterUtil.MasterThread mt = UTIL2.getMiniHBaseCluster().getMasterThread();
        mt.getMaster().abort("for testing");
        mt.join();
        FAIL = false;
        t.join();
        UTIL2.waitFor(60000L, () -> UTIL2.getAdmin().getReplicationPeerSyncReplicationState(PEER_ID) == SyncReplicationState.DOWNGRADE_ACTIVE);
        this.verify(UTIL2, 0, 100);
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        public void remoteProcedureCompleted(long procId) {
            if (FAIL && this.getMasterProcedureExecutor().getProcedure(procId) instanceof SyncReplicationReplayWALRemoteProcedure) {
                throw new RuntimeException("Inject error");
            }
            super.remoteProcedureCompleted(procId);
        }
    }
}

