/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.trace.OpenTelemetryClassRule;
import org.apache.hadoop.hbase.trace.OpenTelemetryTestRule;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestProcedureTracing {
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureTracing.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureTracing.class);
    private static final OpenTelemetryClassRule otelClassRule = OpenTelemetryClassRule.create();
    private static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(StartTestingClusterOption.builder().numWorkers(3).build()).build();
    protected static final ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(miniClusterRule::createAsyncConnection);
    @ClassRule
    public static final TestRule classRule = RuleChain.outerRule((TestRule)otelClassRule).around((TestRule)miniClusterRule).around((TestRule)connectionRule);
    @Rule
    public final OpenTelemetryTestRule otelTestRule = new OpenTelemetryTestRule(otelClassRule);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testCreateOpenDeleteTableSpans() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        AsyncConnection conn = connectionRule.getAsyncConnection();
        AsyncAdmin admin = conn.getAdmin();
        AtomicReference tableRegionsRef = new AtomicReference();
        TraceUtil.trace(() -> {
            try (Table ignored = miniClusterRule.getTestingUtility().createMultiRegionTable(tableName, Bytes.toBytes((String)"fam"), 5);){
                List tableRegions = ((List)conn.getRegionLocator(tableName).getAllRegionLocations().get()).stream().map(HRegionLocation::getRegion).map(RegionInfo::getEncodedName).collect(Collectors.toList());
                tableRegionsRef.set(tableRegions);
            }
            if (((Boolean)admin.tableExists(tableName).get()).booleanValue()) {
                if (((Boolean)admin.isTableEnabled(tableName).get()).booleanValue()) {
                    admin.disableTable(tableName).get();
                }
                admin.deleteTable(tableName).get();
            }
        }, (String)this.name.getMethodName());
        Matcher testSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.name.getMethodName()), (Matcher)SpanDataMatchers.hasEnded());
        Waiter.waitFor((Configuration)conn.getConfiguration(), (long)TimeUnit.MINUTES.toMillis(3L), (Waiter.Predicate)new MatcherPredicate(otelClassRule::getSpans, Matchers.hasItem((Matcher)testSpanMatcher)));
        List<SpanData> spans = otelClassRule.getSpans();
        StringTraceRenderer renderer = new StringTraceRenderer(spans);
        renderer.render(arg_0 -> ((Logger)LOG).debug(arg_0));
        Matcher createTableProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"CreateTableProcedure"), (Matcher)Matchers.containsString((String)("table=" + this.name.getMethodName())))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for a CreateTableProcedure for the test table", spans, (Matcher)Matchers.hasItem((Matcher)createTableProcedureSpanMatcher));
        Matcher transitRegionStateProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"TransitRegionStateProcedure"), (Matcher)Matchers.containsString((String)("table=" + this.name.getMethodName())))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for a TransitRegionStateProcedure for the test table", spans, (Matcher)Matchers.hasItem((Matcher)transitRegionStateProcedureSpanMatcher));
        List tableRegionMatchers = ((List)tableRegionsRef.get()).stream().map(Matchers::containsString).collect(Collectors.toList());
        Matcher openRegionProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"OpenRegionProcedure"), (Matcher)Matchers.anyOf(tableRegionMatchers))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for an OpenRegionProcedure for a region of the test table", spans, (Matcher)Matchers.hasItem((Matcher)openRegionProcedureSpanMatcher));
        Matcher closeRegionProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"CloseRegionProcedure"), (Matcher)Matchers.anyOf(tableRegionMatchers))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for a CloseRegionProcedure for a region of the test table", spans, (Matcher)Matchers.hasItem((Matcher)closeRegionProcedureSpanMatcher));
        Matcher disableTableProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"DisableTableProcedure"), (Matcher)Matchers.containsString((String)("table=" + this.name.getMethodName())))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for a DisableTableProcedure for the test table", spans, (Matcher)Matchers.hasItem((Matcher)disableTableProcedureSpanMatcher));
        Matcher deleteTableProcedureSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"DeleteTableProcedure"), (Matcher)Matchers.containsString((String)("table=" + this.name.getMethodName())))), (Matcher)SpanDataMatchers.hasEnded(), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasAttributes((Matcher)Matchers.allOf((Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"procId"), (Matcher)Matchers.any(Long.class)), (Matcher)AttributesMatchers.containsEntry((AttributeKey)AttributeKey.longKey((String)"parentProcId"), (Matcher)Matchers.any(Long.class)))));
        MatcherAssert.assertThat((String)"Expected to find a span for a DeleteTableProcedure for the test table", spans, (Matcher)Matchers.hasItem((Matcher)deleteTableProcedureSpanMatcher));
    }
}

