/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MasterFailoverWithProceduresTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(MasterFailoverWithProceduresTestBase.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).build();
        UTIL.startMiniCluster(option);
        ProcedureExecutor<MasterProcedureEnv> procExec = MasterFailoverWithProceduresTestBase.getMasterProcedureExecutor();
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    protected static ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    protected static Path getRootDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    protected static void testRecoveryAndDoubleExecution(HBaseTestingUtil testUtil, long procId, int lastStepBeforeFailover) throws Exception {
        ProcedureExecutor procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Procedure proc = procExec.getProcedure(procId);
        for (int i = 0; i < lastStepBeforeFailover; ++i) {
            LOG.info("Restart " + i + " exec state: " + proc);
            ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
            MasterProcedureTestingUtility.restartMasterProcedureExecutor((ProcedureExecutor<MasterProcedureEnv>)procExec);
            ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        }
        ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
        LOG.info("Trigger master failover");
        MasterProcedureTestingUtility.masterFailover(testUtil);
        procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureExecutor)procExec, (long)procId);
    }
}

