/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.locking;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLockManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLockManager.class);
    @Rule
    public TestName testName = new TestName();
    private static final int LOCAL_LOCKS_TIMEOUT = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(TestLockManager.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static MasterServices masterServices;
    private static String namespace;
    private static TableName tableName;
    private static RegionInfo[] tableRegions;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setBoolean("hbase.procedure.check.owner.set", false);
        conf.setInt("hbase.master.procedure.local.master.locks.timeout.ms", 1000);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestLockManager.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
        masterServices = UTIL.getMiniHBaseCluster().getMaster();
        UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)namespace).build());
        UTIL.createTable(tableName, (byte[][])new byte[][]{Bytes.toBytes((String)"fam")}, (byte[][])new byte[][]{Bytes.toBytes((String)"1")});
        List regions = UTIL.getAdmin().getRegions(tableName);
        assert (regions.size() > 0);
        tableRegions = new RegionInfo[regions.size()];
        regions.toArray(tableRegions);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (Procedure proc : this.getMasterProcedureExecutor().getProcedures()) {
            if (!(proc instanceof LockProcedure)) continue;
            ((LockProcedure)proc).unlock((MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment());
            ProcedureTestingUtility.waitProcedure(this.getMasterProcedureExecutor(), (Procedure)proc);
        }
        Assert.assertEquals((long)0L, (long)((MasterProcedureEnv)this.getMasterProcedureExecutor().getEnvironment()).getProcedureScheduler().size());
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    @Test
    public void testMasterLockAcquire() throws Exception {
        LockManager.MasterLock lock = masterServices.getLockManager().createMasterLock(namespace, LockType.EXCLUSIVE, "desc");
        Assert.assertTrue((boolean)lock.tryAcquire(2000L));
        Assert.assertTrue((boolean)lock.getProc().isLocked());
        lock.release();
        Assert.assertEquals(null, (Object)lock.getProc());
    }

    @Test
    public void testMasterLockAcquireTimeout() throws Exception {
        LockManager.MasterLock lock = masterServices.getLockManager().createMasterLock(tableName, LockType.EXCLUSIVE, "desc");
        LockManager.MasterLock lock2 = masterServices.getLockManager().createMasterLock(tableName, LockType.EXCLUSIVE, "desc");
        Assert.assertTrue((boolean)lock.tryAcquire(2000L));
        Assert.assertFalse((boolean)lock2.tryAcquire(500L));
        Assert.assertEquals(null, (Object)lock2.getProc());
        lock.release();
        Assert.assertTrue((boolean)lock2.tryAcquire(2000L));
        Assert.assertTrue((boolean)lock2.getProc().isLocked());
        lock2.release();
    }

    @Test
    public void testMasterLockAcquireTimeoutRegionVsTableExclusive() throws Exception {
        LockManager.MasterLock lock = masterServices.getLockManager().createMasterLock(tableRegions, "desc");
        LockManager.MasterLock lock2 = masterServices.getLockManager().createMasterLock(tableName, LockType.EXCLUSIVE, "desc");
        Assert.assertTrue((boolean)lock.tryAcquire(2000L));
        Assert.assertFalse((boolean)lock2.tryAcquire(500L));
        Assert.assertEquals(null, (Object)lock2.getProc());
        lock.release();
        Assert.assertTrue((boolean)lock2.tryAcquire(2000L));
        Assert.assertTrue((boolean)lock2.getProc().isLocked());
        lock2.release();
    }

    static {
        namespace = "namespace";
        tableName = TableName.valueOf((String)namespace, (String)"table");
    }
}

