/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.master.ReplicationHFileCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestReplicationHFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationHFileCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationHFileCleaner.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Server server;
    private static final TableName tableName;
    private static ReplicationQueueStorage rq;
    private static ReplicationPeers rp;
    private static final String peerId = "TestReplicationHFileCleaner";
    private static Configuration conf;
    private static FileSystem fs;
    private static Map<String, Object> params;
    private Path root;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        server = new DummyServer();
        params = ImmutableMap.of((Object)"master", (Object)server);
        conf.setBoolean("hbase.replication.bulkload.enabled", true);
        HMaster.decorateMasterConfiguration((Configuration)conf);
        TableDescriptor td = ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName);
        TEST_UTIL.getAdmin().createTable(td);
        conf.set("hbase.replication.queue.table.name", tableName.getNameAsString());
        rp = ReplicationFactory.getReplicationPeers((FileSystem)server.getFileSystem(), (ZKWatcher)server.getZooKeeper(), (Configuration)conf);
        rp.init();
        rq = ReplicationStorageFactory.getReplicationQueueStorage((Connection)server.getConnection(), (Configuration)conf);
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws ReplicationException, IOException {
        this.root = TEST_UTIL.getDataTestDirOnTestFS();
        rp.getPeerStorage().addPeer(peerId, ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL.getClusterKey()).build(), true, SyncReplicationState.NONE);
    }

    @After
    public void cleanup() throws ReplicationException {
        try {
            fs.delete(this.root, true);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete files recursively from path " + this.root);
        }
        rq.removeHFileRefs(peerId, rq.getReplicableHFiles(peerId));
        rp.getPeerStorage().removePeer(peerId);
    }

    private ReplicationHFileCleaner createCleaner() {
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        cleaner.init(params);
        return cleaner;
    }

    @Test
    public void testIsFileDeletable() throws IOException, ReplicationException {
        Path file = new Path(this.root, "testIsFileDeletableWithNoHFileRefs");
        fs.createNewFile(file);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        ReplicationHFileCleaner cleaner = this.createCleaner();
        Assert.assertTrue((String)"Cleaner should allow to delete this file as there is no hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
        ArrayList<Pair> files = new ArrayList<Pair>(1);
        files.add(new Pair(null, (Object)file));
        rq.addHFileRefs(peerId, files);
        Assert.assertFalse((String)"Cleaner should not allow to delete this file as there is a hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
    }

    @Test
    public void testGetDeletableFiles() throws Exception {
        int i;
        Path notDeletablefile = new Path(this.root, "testGetDeletableFiles_1");
        fs.createNewFile(notDeletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(notDeletablefile));
        Path deletablefile = new Path(this.root, "testGetDeletableFiles_2");
        fs.createNewFile(deletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(deletablefile));
        ArrayList<FileStatus> files = new ArrayList<FileStatus>(2);
        FileStatus f = new FileStatus();
        f.setPath(deletablefile);
        files.add(f);
        f = new FileStatus();
        f.setPath(notDeletablefile);
        files.add(f);
        ArrayList<Pair> hfiles = new ArrayList<Pair>(1);
        hfiles.add(new Pair(null, (Object)notDeletablefile));
        rq.addHFileRefs(peerId, hfiles);
        ReplicationHFileCleaner cleaner = this.createCleaner();
        Iterator deletableFilesIterator = cleaner.getDeletableFiles(files).iterator();
        for (i = 0; deletableFilesIterator.hasNext() && i < 2; ++i) {
        }
        if (i > 2) {
            Assert.fail((String)("File " + notDeletablefile + " should not be deletable as its hfile reference node is not added."));
        }
        Assert.assertTrue((boolean)((FileStatus)deletableFilesIterator.next()).getPath().equals((Object)deletablefile));
    }

    static {
        tableName = TableName.valueOf((String)"test_cleaner");
        conf = TEST_UTIL.getConfiguration();
        fs = null;
    }

    static class DummyServer
    extends MockServer {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZKWatcher getZooKeeper() {
            try {
                return TEST_UTIL.getZooKeeperWatcher();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Connection getConnection() {
            try {
                return TEST_UTIL.getConnection();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public FileSystem getFileSystem() {
            try {
                return TEST_UTIL.getTestFileSystem();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

