/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleanerBarrier;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLogsCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogsCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestLogsCleaner.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Path OLD_WALS_DIR = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
    private static final Path OLD_PROCEDURE_WALS_DIR = new Path(OLD_WALS_DIR, "masterProcedureWALs");
    private static Configuration conf;
    private static DirScanPool POOL;
    private static String peerId;
    private MasterServices masterServices;
    private ReplicationQueueStorage queueStorage;
    @Rule
    public final TableNameTestRule tableNameRule = new TableNameTestRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        POOL = DirScanPool.getLogCleanerScanPool((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        POOL.shutdownNow();
    }

    @Before
    public void beforeTest() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        fs.delete(OLD_WALS_DIR, true);
        fs.mkdirs(OLD_WALS_DIR);
        TableName tableName = this.tableNameRule.getTableName();
        TableDescriptor td = ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName);
        TEST_UTIL.getAdmin().createTable(td);
        TEST_UTIL.waitTableAvailable(tableName);
        this.queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((Connection)TEST_UTIL.getConnection(), (Configuration)conf, (TableName)tableName);
        this.masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)this.masterServices.getConnection()).thenReturn((Object)TEST_UTIL.getConnection());
        ReplicationPeerManager rpm = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        Mockito.when((Object)this.masterServices.getReplicationPeerManager()).thenReturn((Object)rpm);
        Mockito.when((Object)rpm.getQueueStorage()).thenReturn((Object)this.queueStorage);
        Mockito.when((Object)rpm.getReplicationLogCleanerBarrier()).thenReturn((Object)new ReplicationLogCleanerBarrier());
        Mockito.when((Object)rpm.listPeers(null)).thenReturn(new ArrayList());
        ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)this.masterServices.getServerManager()).thenReturn((Object)sm);
        Mockito.when((Object)sm.getOnlineServersList()).thenReturn(Collections.emptyList());
        ProcedureExecutor procExec = (ProcedureExecutor)Mockito.mock(ProcedureExecutor.class);
        Mockito.when((Object)this.masterServices.getMasterProcedureExecutor()).thenReturn((Object)procExec);
        Mockito.when((Object)procExec.getProcedures()).thenReturn(Collections.emptyList());
    }

    @Test
    public void testLogCleaning() throws Exception {
        Path fileName;
        int i;
        long ttlWAL = 2000L;
        long ttlProcedureWAL = 4000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttlWAL);
        conf.setLong("hbase.master.procedurewalcleaner.ttl", ttlProcedureWAL);
        HMaster.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), StandardCharsets.UTF_8.name());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(OLD_PROCEDURE_WALS_DIR);
        long now = EnvironmentEdgeManager.currentTime();
        fs.createNewFile(new Path(OLD_WALS_DIR, "a"));
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + ".a"));
        for (i = 1; i <= 5; ++i) {
            fileName = new Path(OLD_PROCEDURE_WALS_DIR, String.format("pv2-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlProcedureWAL - ttlWAL);
        for (i = 1; i <= 30; ++i) {
            fileName = new Path(OLD_WALS_DIR, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
        }
        this.masterServices.getReplicationPeerManager().listPeers(null).add(new ReplicationPeerDescription(peerId, true, null, null));
        this.queueStorage.setOffset(new ReplicationQueueId(server.getServerName(), peerId), fakeMachineName, new ReplicationGroupOffset(fakeMachineName + "." + (now - 3L), 0L), Collections.emptyMap());
        for (i = 6; i <= 10; ++i) {
            fileName = new Path(OLD_PROCEDURE_WALS_DIR, String.format("pv2-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlWAL);
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + "." + now));
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + "." + (now + ttlWAL)));
        Object[] status = fs.listStatus(OLD_WALS_DIR);
        LOG.info("File status: {}", (Object)Arrays.toString(status));
        Assert.assertEquals((long)35L, (long)fs.listStatus(OLD_WALS_DIR).length);
        Assert.assertEquals((long)10L, (long)fs.listStatus(OLD_PROCEDURE_WALS_DIR).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, OLD_WALS_DIR, POOL, (Map)ImmutableMap.of((Object)"master", (Object)this.masterServices));
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, () -> 6 == fs.listStatus(OLD_WALS_DIR).length);
        TEST_UTIL.waitFor(1000L, () -> 5 == fs.listStatus(OLD_PROCEDURE_WALS_DIR).length);
        if (LOG.isDebugEnabled()) {
            Object[] statusOldWALs = fs.listStatus(OLD_WALS_DIR);
            Object[] statusProcedureWALs = fs.listStatus(OLD_PROCEDURE_WALS_DIR);
            LOG.debug("Kept log file for oldWALs: {}", (Object)Arrays.toString(statusOldWALs));
            LOG.debug("Kept log file for masterProcedureWALs: {}", (Object)Arrays.toString(statusProcedureWALs));
        }
    }

    @Test
    public void testOnConfigurationChange() throws Exception {
        DummyServer server = new DummyServer();
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        LogCleaner cleaner = new LogCleaner(3000, (Stoppable)server, conf, (FileSystem)fs, OLD_WALS_DIR, POOL, (Map)ImmutableMap.of((Object)"master", (Object)this.masterServices));
        int size = cleaner.getSizeOfCleaners();
        Assert.assertEquals((long)60000L, (long)cleaner.getCleanerThreadTimeoutMsec());
        int numOfFiles = 10;
        this.createFiles((FileSystem)fs, OLD_WALS_DIR, numOfFiles);
        FileStatus[] status = fs.listStatus(OLD_WALS_DIR);
        Assert.assertEquals((long)numOfFiles, (long)status.length);
        Thread thread = new Thread(() -> cleaner.chore());
        thread.setDaemon(true);
        thread.start();
        int sizeToChange = 4;
        long threadTimeoutToChange = 30000L;
        conf.setInt("hbase.oldwals.cleaner.thread.size", size + sizeToChange);
        conf.setLong("hbase.oldwals.cleaner.thread.timeout.msec", threadTimeoutToChange);
        cleaner.onConfigurationChange(conf);
        Assert.assertEquals((long)(sizeToChange + size), (long)cleaner.getSizeOfCleaners());
        Assert.assertEquals((long)threadTimeoutToChange, (long)cleaner.getCleanerThreadTimeoutMsec());
        thread.join();
        status = fs.listStatus(OLD_WALS_DIR);
        Assert.assertEquals((long)0L, (long)status.length);
    }

    private void createFiles(FileSystem fs, Path parentDir, int numOfFiles) throws IOException {
        for (int i = 0; i < numOfFiles; ++i) {
            int xMega = 1 + ThreadLocalRandom.current().nextInt(1, 4);
            byte[] M = new byte[Math.toIntExact(0x100000L * (long)xMega)];
            Bytes.random((byte[])M);
            try (FSDataOutputStream fsdos = fs.create(new Path(parentDir, "file-" + i));){
                fsdos.write(M);
                continue;
            }
        }
    }

    static {
        peerId = "1";
    }

    private static final class DummyServer
    extends MockServer {
        private DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

