/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestCleanerChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCleanerChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanerChore.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static DirScanPool POOL;
    private static ChoreService SERVICE;

    @BeforeClass
    public static void setup() {
        POOL = DirScanPool.getHFileCleanerScanPool((Configuration)UTIL.getConfiguration());
        SERVICE = new ChoreService("cleaner", 2, true);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SERVICE.shutdown();
        UTIL.cleanupTestDir();
        POOL.shutdownNow();
    }

    @Test
    public void testSavesFilesOnRequest() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, NeverDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertTrue((String)"File shouldn't have been deleted", (boolean)fs.exists(file));
        Assert.assertTrue((String)"directory shouldn't have been deleted", (boolean)fs.exists(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void retriesIOExceptionInStatus() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        Path child = new Path(testDir, "child");
        Path file = new Path(child, "file");
        fs.mkdirs(child);
        fs.create(file).close();
        Assert.assertTrue((String)"test file didn't get created.", (boolean)fs.exists(file));
        final AtomicBoolean fails = new AtomicBoolean(true);
        FilterFileSystem filtered = new FilterFileSystem(fs){

            public FileStatus[] listStatus(Path f) throws IOException {
                if (fails.get()) {
                    throw new IOException("whomp whomp.");
                }
                return this.fs.listStatus(f);
            }
        };
        AllValidPaths chore = new AllValidPaths("test-retry-ioe", stop, conf, (FileSystem)filtered, testDir, confKey, POOL);
        SERVICE.scheduleChore((ScheduledChore)chore);
        try {
            CompletableFuture succFuture;
            CompletableFuture errorFuture = chore.triggerCleanerNow();
            ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
                Boolean cfr_ignored_0 = (Boolean)errorFuture.get();
            });
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(IOException.class));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"whomp"));
            Assert.assertTrue((String)"test rig failed to inject failure.", (boolean)fs.exists(file));
            Assert.assertTrue((String)"test rig failed to inject failure.", (boolean)fs.exists(child));
            fails.set(false);
            while ((succFuture = chore.triggerCleanerNow()) == errorFuture) {
            }
            Assert.assertTrue((String)"chore should claim it succeeded.", (boolean)((Boolean)succFuture.get()));
            Assert.assertFalse((String)"file should have been destroyed.", (boolean)fs.exists(file));
            Assert.assertFalse((String)"directory should have been destroyed.", (boolean)fs.exists(child));
        }
        finally {
            chore.cancel();
        }
    }

    @Test
    public void testDeletesEmptyDirectories() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path emptyChild = new Path(parent, "emptyChild");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.mkdirs(emptyChild);
        fs.create(file).close();
        Path topFile = new Path(testDir, "topFile");
        fs.create(topFile).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(topFile));
        chore.chore();
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(topFile));
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(file));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(child));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testDoesNotCheckDirectories() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        Assert.assertTrue((String)"Test parent didn't get created.", (boolean)fs.exists(parent));
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        FileStatus fStat = fs.getFileStatus(parent);
        chore.chore();
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.never()))).isFileDeletable(fStat);
        Mockito.reset((Object[])new AlwaysDelete[]{spy});
    }

    @Test
    public void testStoppedCleanerDoesNotDeleteFiles() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        Path topFile = new Path(testDir, "topFile");
        fs.create(topFile).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(topFile));
        stop.stop("testing stop");
        chore.chore();
        Assert.assertTrue((String)"File got deleted while chore was stopped", (boolean)fs.exists(topFile));
    }

    @Test
    public void testCleanerDoesNotDeleteDirectoryWithLateAddedFiles() throws IOException {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        final Path testDir = UTIL.getDataTestDir();
        final FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        final Path addedFile = new Path(parent, "addedFile");
        ((AlwaysDelete)((Object)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                fs.create(addedFile).close();
                CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)testDir, (Logger)LOG);
                return (Boolean)invocation.callRealMethod();
            }
        }).when((Object)spy))).isFileDeletable((FileStatus)Mockito.any());
        chore.chore();
        Assert.assertTrue((String)"Added file unexpectedly deleted", (boolean)fs.exists(addedFile));
        Assert.assertTrue((String)"Parent directory deleted unexpectedly", (boolean)fs.exists(parent));
        Assert.assertFalse((String)"Original file unexpectedly retained", (boolean)fs.exists(file));
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).isFileDeletable((FileStatus)Mockito.any());
        Mockito.reset((Object[])new AlwaysDelete[]{spy});
    }

    @Test
    public void testNoExceptionFromDirectoryWithRacyChildren() throws Exception {
        UTIL.cleanupTestDir();
        StoppableImplementation stop = new StoppableImplementation();
        HBaseTestingUtil localUtil = new HBaseTestingUtil();
        Configuration conf = localUtil.getConfiguration();
        final Path testDir = UTIL.getDataTestDir();
        final FileSystem fs = UTIL.getTestFileSystem();
        LOG.debug("Writing test data to: " + testDir);
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        AlwaysDelete delegate = (AlwaysDelete)((Object)chore.cleanersChain.get(0));
        AlwaysDelete spy = (AlwaysDelete)((Object)Mockito.spy((Object)((Object)delegate)));
        chore.cleanersChain.set(0, spy);
        Path parent = new Path(testDir, "parent");
        Path file = new Path(parent, "someFile");
        fs.mkdirs(parent);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        final Path racyFile = new Path(parent, "addedFile");
        ((AlwaysDelete)((Object)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                fs.create(racyFile).close();
                CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)testDir, (Logger)LOG);
                return (Boolean)invocation.callRealMethod();
            }
        }).when((Object)spy))).isFileDeletable((FileStatus)Mockito.any());
        chore.chore();
        Assert.assertTrue((String)"Added file unexpectedly deleted", (boolean)fs.exists(racyFile));
        Assert.assertTrue((String)"Parent directory deleted unexpectedly", (boolean)fs.exists(parent));
        Assert.assertFalse((String)"Original file unexpectedly retained", (boolean)fs.exists(file));
        ((AlwaysDelete)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).isFileDeletable((FileStatus)Mockito.any());
    }

    @Test
    public void testDeleteFileWithCleanerEnabled() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        chore.setEnabled(true);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertFalse((String)"File didn't get deleted", (boolean)fs.exists(file));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(child));
        Assert.assertFalse((String)"Empty directory didn't get deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testDeleteFileWithCleanerDisabled() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        chore.setEnabled(false);
        Path parent = new Path(testDir, "parent");
        Path child = new Path(parent, "child");
        Path file = new Path(child, "someFile");
        fs.mkdirs(child);
        fs.create(file).close();
        Assert.assertTrue((String)"Test file didn't get created.", (boolean)fs.exists(file));
        chore.chore();
        Assert.assertTrue((String)"File got deleted with cleaner disabled", (boolean)fs.exists(file));
        Assert.assertTrue((String)"Directory got deleted", (boolean)fs.exists(child));
        Assert.assertTrue((String)"Directory got deleted", (boolean)fs.exists(parent));
    }

    @Test
    public void testOnConfigurationChange() throws Exception {
        int availableProcessorNum = Runtime.getRuntime().availableProcessors();
        if (availableProcessorNum == 1) {
            return;
        }
        int initPoolSize = availableProcessorNum / 2;
        int changedPoolSize = availableProcessorNum;
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        conf.set("hbase.cleaner.scan.dir.concurrent.size", String.valueOf(initPoolSize));
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        chore.setEnabled(true);
        int dirNums = 6;
        Path[] subdirs = new Path[dirNums];
        for (int i = 0; i < dirNums; ++i) {
            subdirs[i] = new Path(testDir, "subdir-" + i);
            fs.mkdirs(subdirs[i]);
        }
        for (Path subdir : subdirs) {
            this.createFiles(fs, subdir, 6);
        }
        Thread t = new Thread(() -> chore.chore());
        t.setDaemon(true);
        t.start();
        conf.set("hbase.cleaner.scan.dir.concurrent.size", String.valueOf(changedPoolSize));
        POOL.onConfigurationChange(conf);
        Assert.assertEquals((long)changedPoolSize, (long)chore.getChorePoolSize());
        t.join();
    }

    @Test
    public void testOnConfigurationChangeLogCleaner() throws Exception {
        int availableProcessorNum = Runtime.getRuntime().availableProcessors();
        if (availableProcessorNum == 1) {
            return;
        }
        DirScanPool pool = DirScanPool.getLogCleanerScanPool((Configuration)UTIL.getConfiguration());
        int initPoolSize = availableProcessorNum / 2;
        int changedPoolSize = availableProcessorNum;
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        conf.set("hbase.log.cleaner.scan.dir.concurrent.size", String.valueOf(initPoolSize));
        final AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, pool);
        chore.setEnabled(true);
        int dirNums = 6;
        Path[] subdirs = new Path[dirNums];
        for (int i = 0; i < dirNums; ++i) {
            subdirs[i] = new Path(testDir, "subdir-" + i);
            fs.mkdirs(subdirs[i]);
        }
        for (Path subdir : subdirs) {
            this.createFiles(fs, subdir, 6);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                chore.chore();
            }
        });
        t.setDaemon(true);
        t.start();
        conf.set("hbase.log.cleaner.scan.dir.concurrent.size", String.valueOf(changedPoolSize));
        pool.onConfigurationChange(conf);
        Assert.assertEquals((long)changedPoolSize, (long)chore.getChorePoolSize());
        t.join();
    }

    @Test
    public void testMinimumNumberOfThreads() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        conf.set("hbase.cleaner.scan.dir.concurrent.size", "2");
        int numProcs = Runtime.getRuntime().availableProcessors();
        Assert.assertEquals((long)numProcs, (long)CleanerChore.calculatePoolSize((String)Integer.toString(numProcs)));
        Assert.assertEquals((long)numProcs, (long)CleanerChore.calculatePoolSize((String)Integer.toString(numProcs + 2)));
        Assert.assertEquals((long)1L, (long)CleanerChore.calculatePoolSize((String)"0.0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerCleaner() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        fs.mkdirs(testDir);
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, AlwaysDelete.class.getName());
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL);
        try {
            SERVICE.scheduleChore((ScheduledChore)chore);
            Assert.assertTrue((boolean)((Boolean)chore.triggerCleanerNow().get()));
            chore.setEnabled(false);
            Assert.assertTrue((boolean)((Boolean)chore.triggerCleanerNow().get()));
        }
        finally {
            chore.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRescheduleNoConcurrencyRun() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = UTIL.getConfiguration();
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        fs.mkdirs(testDir);
        fs.createNewFile(new Path(testDir, "test"));
        String confKey = "hbase.test.cleaner.delegates";
        conf.set(confKey, GetConcurrency.class.getName());
        AtomicInteger maxConcurrency = new AtomicInteger();
        AllValidPaths chore = new AllValidPaths("test-file-cleaner", stop, conf, fs, testDir, confKey, POOL, (Map<String, Object>)ImmutableMap.of((Object)"maxConcurrency", (Object)maxConcurrency));
        try {
            SERVICE.scheduleChore((ScheduledChore)chore);
            for (int i = 0; i < 100; ++i) {
                chore.triggerNow();
                Thread.sleep(5 + ThreadLocalRandom.current().nextInt(5));
            }
            Thread.sleep(1000L);
            Assert.assertFalse((boolean)((Boolean)chore.triggerCleanerNow().get()));
            Assert.assertEquals((long)1L, (long)maxConcurrency.get());
        }
        finally {
            chore.cancel();
        }
    }

    private void createFiles(FileSystem fs, Path parentDir, int numOfFiles) throws IOException {
        for (int i = 0; i < numOfFiles; ++i) {
            int xMega = 1 + ThreadLocalRandom.current().nextInt(3);
            try (FSDataOutputStream fsdos = fs.create(new Path(parentDir, "file-" + i));){
                for (int m = 0; m < xMega; ++m) {
                    byte[] M = new byte[0x100000];
                    Bytes.random((byte[])M);
                    fsdos.write(M);
                }
                continue;
            }
        }
    }

    public static class GetConcurrency
    extends BaseHFileCleanerDelegate {
        private final AtomicInteger concurrency = new AtomicInteger();
        private AtomicInteger maxConcurrency;

        public void init(Map<String, Object> params) {
            this.maxConcurrency = (AtomicInteger)params.get("maxConcurrency");
        }

        public void preClean() {
            int cur;
            int c = this.concurrency.incrementAndGet();
            while (c > (cur = this.maxConcurrency.get()) && !this.maxConcurrency.compareAndSet(cur, c)) {
            }
        }

        public void postClean() {
            this.concurrency.decrementAndGet();
        }

        protected boolean isFileDeletable(FileStatus fStat) {
            Threads.sleepWithoutInterrupt((long)(10 + ThreadLocalRandom.current().nextInt(10)));
            return false;
        }
    }

    public static class NeverDelete
    extends BaseHFileCleanerDelegate {
        public boolean isFileDeletable(FileStatus fStat) {
            return false;
        }
    }

    public static class AlwaysDelete
    extends BaseHFileCleanerDelegate {
        public boolean isFileDeletable(FileStatus fStat) {
            return true;
        }
    }

    private static class AllValidPaths
    extends CleanerChore<BaseHFileCleanerDelegate> {
        public AllValidPaths(String name, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confkey, DirScanPool pool) {
            super(name, Integer.MAX_VALUE, s, conf, fs, oldFileDir, confkey, pool);
        }

        public AllValidPaths(String name, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confkey, DirScanPool pool, Map<String, Object> params) {
            super(name, Integer.MAX_VALUE, s, conf, fs, oldFileDir, confkey, pool, params, null);
        }

        protected boolean validate(Path file) {
            return true;
        }
    }
}

