/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.LoadOnlyFavoredStochasticBalancer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Category(value={MediumTests.class})
public class TestFavoredStochasticLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFavoredStochasticLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFavoredStochasticLoadBalancer.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final int SLAVES = 8;
    private static final int REGION_NUM = 24;
    private Admin admin;
    private HMaster master;
    private SingleProcessHBaseCluster cluster;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", LoadOnlyFavoredStochasticBalancer.class, LoadBalancer.class);
    }

    @Before
    public void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(8);
        TEST_UTIL.getDFSCluster().waitClusterUp();
        this.cluster = TEST_UTIL.getMiniHBaseCluster();
        this.master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        this.admin = TEST_UTIL.getAdmin();
        this.admin.balancerSwitch(false, true);
    }

    @After
    public void stopCluster() throws Exception {
        TEST_UTIL.cleanupTestDir();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBasicBalance() throws Exception {
        TableName tableName = TableName.valueOf((String)"testBasicBalance");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(this.admin.getConnection().getTable(tableName), HConstants.CATALOG_FAMILY);
        this.admin.flush(tableName);
        this.compactTable(tableName);
        JVMClusterUtil.RegionServerThread rs1 = this.cluster.startRegionServerAndWait(10000L);
        JVMClusterUtil.RegionServerThread rs2 = this.cluster.startRegionServerAndWait(10000L);
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition(120000L);
        List hris = this.admin.getRegions(rs1.getRegionServer().getServerName());
        for (RegionInfo hri : hris) {
            Assert.assertFalse((String)("New RS contains regions belonging to table: " + tableName), (boolean)hri.getTable().equals((Object)tableName));
        }
        hris = this.admin.getRegions(rs2.getRegionServer().getServerName());
        for (RegionInfo hri : hris) {
            Assert.assertFalse((String)("New RS contains regions belonging to table: " + tableName), (boolean)hri.getTable().equals((Object)tableName));
        }
    }

    @Test
    public void testRoundRobinAssignment() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRoundRobinAssignment");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.loadTable(this.admin.getConnection().getTable(tableName), HConstants.CATALOG_FAMILY);
        this.admin.flush(tableName);
        RSGroupBasedLoadBalancer balancer = this.master.getLoadBalancer();
        List regions = this.admin.getRegions(tableName);
        regions.addAll(this.admin.getRegions(TableName.META_TABLE_NAME));
        ArrayList servers = Lists.newArrayList(this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet());
        Map map = balancer.roundRobinAssignment(regions, (List)servers);
        for (List regionInfos : map.values()) {
            regions.removeAll(regionInfos);
        }
        Assert.assertEquals((String)"No region should be missed by balancer", (long)0L, (long)regions.size());
    }

    @Test
    public void testBasicRegionPlacementAndReplicaLoad() throws Exception {
        String tableName = "testBasicRegionPlacement";
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableDescriptor.getTableName());
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List regionsOfTable = this.admin.getRegions(TableName.valueOf((String)tableName));
        for (RegionInfo rInfo : regionsOfTable) {
            HashSet favNodes = Sets.newHashSet((Iterable)fnm.getFavoredNodes(rInfo));
            Assert.assertNotNull((Object)favNodes);
            Assert.assertEquals((long)3L, (long)favNodes.size());
        }
        Map replicaLoadMap = fnm.getReplicaLoad((List)Lists.newArrayList(this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()));
        Assert.assertTrue((String)"Not all replica load collected.", (this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size() == replicaLoadMap.size() ? 1 : 0) != 0);
        for (Map.Entry entry : replicaLoadMap.entrySet()) {
            Assert.assertTrue((((List)entry.getValue()).size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)((List)entry.getValue()).get(0) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)((List)entry.getValue()).get(1) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)((List)entry.getValue()).get(2) >= 0 ? 1 : 0) != 0);
        }
        this.admin.disableTable(TableName.valueOf((String)tableName));
        this.admin.deleteTable(TableName.valueOf((String)tableName));
        replicaLoadMap = fnm.getReplicaLoad((List)Lists.newArrayList(this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()));
        Assert.assertTrue((String)("replica load found " + replicaLoadMap.size() + " instead of 0."), (replicaLoadMap.size() == this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size() ? 1 : 0) != 0);
    }

    @Test
    public void testRandomAssignmentWithNoFavNodes() throws Exception {
        String tableName = "testRandomAssignmentWithNoFavNodes";
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testRandomAssignmentWithNoFavNodes")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor);
        TEST_UTIL.waitTableAvailable(tableDescriptor.getTableName());
        RegionInfo hri = (RegionInfo)this.admin.getRegions(TableName.valueOf((String)"testRandomAssignmentWithNoFavNodes")).get(0);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        fnm.deleteFavoredNodesForRegions((Collection)Lists.newArrayList((Object[])new RegionInfo[]{hri}));
        Assert.assertNull((String)"Favored nodes not found null after delete", (Object)fnm.getFavoredNodes(hri));
        RSGroupBasedLoadBalancer balancer = this.master.getLoadBalancer();
        ServerName destination = balancer.randomAssignment(hri, (List)Lists.newArrayList((Iterable)this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet().stream().collect(Collectors.toList())));
        Assert.assertNotNull((Object)destination);
        List favoredNodes = fnm.getFavoredNodes(hri);
        Assert.assertNotNull((Object)favoredNodes);
        boolean containsFN = false;
        for (ServerName sn : favoredNodes) {
            if (!ServerName.isSameAddress((ServerName)destination, (ServerName)sn)) continue;
            containsFN = true;
        }
        Assert.assertTrue((String)"Destination server does not belong to favored nodes.", (boolean)containsFN);
    }

    @Test
    public void testBalancerWithoutFavoredNodes() throws Exception {
        TableName tableName = TableName.valueOf((String)"testBalancerWithoutFavoredNodes");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        RegionInfo region = (RegionInfo)this.admin.getRegions(tableName).get(0);
        LOG.info("Region thats supposed to be in transition: " + region);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List currentFN = fnm.getFavoredNodes(region);
        Assert.assertNotNull((Object)currentFN);
        fnm.deleteFavoredNodesForRegions((Collection)Lists.newArrayList((Object[])new RegionInfo[]{region}));
        RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition();
        this.admin.assign(region.getEncodedNameAsBytes());
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        currentFN = fnm.getFavoredNodes(region);
        Assert.assertNotNull((Object)currentFN);
        Assert.assertEquals((String)"Expected number of FN not present", (long)3L, (long)currentFN.size());
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.checkFavoredNodeAssignments(tableName, fnm, regionStates);
    }

    @Ignore
    @Test
    public void testMisplacedRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMisplacedRegions");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        final RegionInfo misplacedRegion = (RegionInfo)this.admin.getRegions(tableName).get(0);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List currentFN = fnm.getFavoredNodes(misplacedRegion);
        Assert.assertNotNull((Object)currentFN);
        ArrayList serversForNewFN = Lists.newArrayList();
        for (ServerName sn : this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            serversForNewFN.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L));
        }
        for (ServerName sn : currentFN) {
            serversForNewFN.remove(sn);
        }
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper((List)serversForNewFN, conf);
        helper.initialize();
        List newFavoredNodes = helper.generateFavoredNodes(misplacedRegion);
        Assert.assertNotNull((Object)newFavoredNodes);
        Assert.assertEquals((long)3L, (long)newFavoredNodes.size());
        HashMap regionFNMap = Maps.newHashMap();
        regionFNMap.put(misplacedRegion, newFavoredNodes);
        fnm.updateFavoredNodes((Map)regionFNMap);
        final RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        final ServerName current = regionStates.getRegionServerOfRegion(misplacedRegion);
        Assert.assertNull((String)"Misplaced region is still hosted on favored node, not expected.", (Object)FavoredNodesPlan.getFavoredServerPosition((List)fnm.getFavoredNodes(misplacedRegion), (ServerName)current));
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitFor(120000L, 30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName host = regionStates.getRegionServerOfRegion(misplacedRegion);
                return !ServerName.isSameAddress((ServerName)host, (ServerName)current);
            }
        });
        this.checkFavoredNodeAssignments(tableName, fnm, regionStates);
    }

    @Test
    public void test2FavoredNodesDead() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAllFavoredNodesDead");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        final RegionInfo region = (RegionInfo)this.admin.getRegions(tableName).get(0);
        LOG.info("Region that's supposed to be in transition: " + region);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List currentFN = fnm.getFavoredNodes(region);
        Assert.assertNotNull((Object)currentFN);
        ArrayList serversToStop = Lists.newArrayList((Iterable)currentFN);
        serversToStop.remove(currentFN.get(0));
        this.stopServersAndWaitUntilProcessed(serversToStop);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        final RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        TEST_UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return regionStates.getRegionState(region).isOpened();
            }
        });
        Assert.assertEquals((String)"Not all regions are online", (long)24L, (long)this.admin.getRegions(tableName).size());
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.checkFavoredNodeAssignments(tableName, fnm, regionStates);
    }

    @Ignore
    @Test
    public void testAllFavoredNodesDead() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAllFavoredNodesDead");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        final RegionInfo region = (RegionInfo)this.admin.getRegions(tableName).get(0);
        LOG.info("Region that's supposed to be in transition: " + region);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List currentFN = fnm.getFavoredNodes(region);
        Assert.assertNotNull((Object)currentFN);
        this.stopServersAndWaitUntilProcessed(currentFN);
        final RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        TEST_UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return regionStates.getRegionState(region).isFailedOpen();
            }
        });
        Assert.assertTrue((String)("Region: " + region + " should be RIT"), (boolean)regionStates.getRegionState(region).isFailedOpen());
        ArrayList serversForNewFN = Lists.newArrayList();
        for (ServerName sn : this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            serversForNewFN.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L));
        }
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper((List)serversForNewFN, conf);
        helper.initialize();
        for (RegionStateNode regionState : regionStates.getRegionsInTransition()) {
            RegionInfo regionInfo = regionState.getRegionInfo();
            List newFavoredNodes = helper.generateFavoredNodes(regionInfo);
            Assert.assertNotNull((Object)newFavoredNodes);
            Assert.assertEquals((long)3L, (long)newFavoredNodes.size());
            LOG.info("Region: " + regionInfo.getEncodedName() + " FN: " + newFavoredNodes);
            HashMap regionFNMap = Maps.newHashMap();
            regionFNMap.put(regionInfo, newFavoredNodes);
            fnm.updateFavoredNodes((Map)regionFNMap);
            LOG.info("Assigning region: " + regionInfo.getEncodedName());
            this.admin.assign(regionInfo.getEncodedNameAsBytes());
        }
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertEquals((String)"Not all regions are online", (long)24L, (long)this.admin.getRegions(tableName).size());
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.checkFavoredNodeAssignments(tableName, fnm, regionStates);
    }

    @Ignore
    @Test
    public void testAllFavoredNodesDeadMasterRestarted() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAllFavoredNodesDeadMasterRestarted");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(tableDescriptor, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 24);
        TEST_UTIL.waitTableAvailable(tableName);
        final RegionInfo region = (RegionInfo)this.admin.getRegions(tableName).get(0);
        LOG.info("Region that's supposed to be in transition: " + region);
        FavoredNodesManager fnm = this.master.getFavoredNodesManager();
        List currentFN = fnm.getFavoredNodes(region);
        Assert.assertNotNull((Object)currentFN);
        this.stopServersAndWaitUntilProcessed(currentFN);
        final RegionStates regionStatesBeforeMaster = this.master.getAssignmentManager().getRegionStates();
        TEST_UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return regionStatesBeforeMaster.getRegionState(region).isFailedOpen();
            }
        });
        Assert.assertTrue((String)("Region: " + region + " should be RIT"), (boolean)regionStatesBeforeMaster.getRegionState(region).isFailedOpen());
        ArrayList rit = Lists.newArrayList();
        for (RegionStateNode regionState : regionStatesBeforeMaster.getRegionsInTransition()) {
            RegionInfo regionInfo = regionState.getRegionInfo();
            LOG.debug("Region in transition after stopping FN's: " + regionInfo);
            rit.add(regionInfo);
            Assert.assertTrue((String)("Region: " + regionInfo + " should be RIT"), (boolean)regionStatesBeforeMaster.getRegionState(regionInfo).isFailedOpen());
            Assert.assertEquals((String)("Region: " + regionInfo + " does not belong to table: " + tableName), (Object)tableName, (Object)regionInfo.getTable());
        }
        Configuration conf = this.cluster.getConf();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 5);
        this.cluster.stopMaster(this.master.getServerName());
        this.cluster.waitForMasterToStop(this.master.getServerName(), 60000L);
        this.cluster.startMaster();
        this.cluster.waitForActiveAndReadyMaster();
        this.master = this.cluster.getMaster();
        fnm = this.master.getFavoredNodesManager();
        RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        Assert.assertTrue((String)("Region: " + region + " should be RIT"), (boolean)regionStates.getRegionState(region).isFailedOpen());
        for (Object regionInfo : rit) {
            Assert.assertTrue((String)("Region: " + regionInfo + " should be RIT"), (boolean)regionStates.getRegionState((RegionInfo)regionInfo).isFailedOpen());
        }
        ArrayList serversForNewFN = Lists.newArrayList();
        for (ServerName sn : this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            serversForNewFN.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L));
        }
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper((List)serversForNewFN, conf);
        helper.initialize();
        for (RegionInfo regionInfo : rit) {
            List newFavoredNodes = helper.generateFavoredNodes(regionInfo);
            Assert.assertNotNull((Object)newFavoredNodes);
            Assert.assertEquals((long)3L, (long)newFavoredNodes.size());
            LOG.info("Region: " + regionInfo.getEncodedName() + " FN: " + newFavoredNodes);
            HashMap regionFNMap = Maps.newHashMap();
            regionFNMap.put(regionInfo, newFavoredNodes);
            fnm.updateFavoredNodes((Map)regionFNMap);
            LOG.info("Assigning region: " + regionInfo.getEncodedName());
            this.admin.assign(regionInfo.getEncodedNameAsBytes());
        }
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertEquals((String)"Not all regions are online", (long)24L, (long)this.admin.getRegions(tableName).size());
        this.admin.balancerSwitch(true, true);
        Assert.assertTrue((String)"Balancer did not run", (boolean)this.admin.balance());
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.checkFavoredNodeAssignments(tableName, fnm, regionStates);
    }

    private void checkFavoredNodeAssignments(TableName tableName, FavoredNodesManager fnm, RegionStates regionStates) throws IOException {
        for (RegionInfo hri : this.admin.getRegions(tableName)) {
            ServerName host = regionStates.getRegionServerOfRegion(hri);
            Assert.assertNotNull((String)("Region: " + hri.getEncodedName() + " not on FN, current: " + host + " FN list: " + fnm.getFavoredNodes(hri)), (Object)FavoredNodesPlan.getFavoredServerPosition((List)fnm.getFavoredNodes(hri), (ServerName)host));
        }
    }

    private void stopServersAndWaitUntilProcessed(List<ServerName> currentFN) throws Exception {
        for (ServerName sn : currentFN) {
            for (JVMClusterUtil.RegionServerThread rst : this.cluster.getLiveRegionServerThreads()) {
                if (!ServerName.isSameAddress((ServerName)sn, (ServerName)rst.getRegionServer().getServerName())) continue;
                LOG.info("Shutting down server: " + sn);
                this.cluster.stopRegionServer(rst.getRegionServer().getServerName());
                this.cluster.waitForRegionServerToStop(rst.getRegionServer().getServerName(), 60000L);
            }
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !TestFavoredStochasticLoadBalancer.this.master.getServerManager().areDeadServersInProgress();
            }
        });
        Assert.assertEquals((String)"Not all servers killed", (long)(8 - currentFN.size()), (long)this.cluster.getLiveRegionServerThreads().size());
    }

    private void compactTable(TableName tableName) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.cluster.getRegionServerThreads()) {
            for (HRegion region : t.getRegionServer().getRegions(tableName)) {
                region.compact(true);
            }
        }
    }
}

