/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRogueRSAssignment {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRogueRSAssignment.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRogueRSAssignment.class);
    @Rule
    public final TestName name = new TestName();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final int initialRegionCount = 3;
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final Configuration conf = UTIL.getConfiguration();
    private static Admin admin;
    private static SingleProcessHBaseCluster cluster;
    private static HMaster master;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.assignment.maximum.attempts", 3);
        conf.setInt("hbase.master.maximum.ping.server.attempts", 3);
        conf.setInt("hbase.master.ping.server.retry.sleep.interval", 1);
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestRogueRSAssignment.setupConf(conf);
        UTIL.startMiniCluster(2);
        cluster = UTIL.getHBaseCluster();
        Assert.assertNotNull((Object)cluster);
        admin = UTIL.getAdmin();
        Assert.assertNotNull((Object)admin);
        master = cluster.getMaster();
        Assert.assertNotNull((Object)master);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
            cluster = null;
            admin = null;
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws IOException {
        admin.balancerSwitch(false, true);
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor td : UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + td.getTableName());
            UTIL.deleteTable(td.getTableName());
        }
        admin.balancerSwitch(true, false);
    }

    @Test
    @Ignore
    public void testReportRSWithWrongRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<RegionInfo> tableRegions = this.createTable(tableName);
        ServerName sn = ServerName.parseVersionedServerName((byte[])ServerName.valueOf((String)"1.example.org", (int)1, (long)EnvironmentEdgeManager.currentTime()).getVersionedBytes());
        RegionServerStatusProtos.RegionServerReportRequest.Builder request = this.makeRSReportRequestWithRegions(sn, tableRegions.get(1));
        this.exception.expect(ServiceException.class);
        this.exception.expectCause(Is.isA(YouAreDeadException.class));
        RegionServerStatusProtos.RegionServerReportResponse response = master.getMasterRpcServices().regionServerReport(null, request.build());
    }

    private RegionServerStatusProtos.RegionServerReportRequest.Builder makeRSReportRequestWithRegions(ServerName sn, RegionInfo ... regions) {
        ClusterStatusProtos.ServerLoad.Builder sl = ClusterStatusProtos.ServerLoad.newBuilder();
        for (int i = 0; i < regions.length; ++i) {
            HBaseProtos.RegionSpecifier.Builder rs = HBaseProtos.RegionSpecifier.newBuilder();
            rs.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
            rs.setValue(UnsafeByteOperations.unsafeWrap((byte[])regions[i].getRegionName()));
            ClusterStatusProtos.RegionLoad.Builder rl = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rs.build());
            sl.addRegionLoads(i, rl.build());
        }
        return RegionServerStatusProtos.RegionServerReportRequest.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)sn)).setLoad(sl);
    }

    private List<RegionInfo> createTable(TableName tableName) throws Exception {
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        tdBuilder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build());
        byte[][] rows = new byte[2][];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = Bytes.toBytes((String)String.format("%d", i));
        }
        admin.createTable(tdBuilder.build(), (byte[][])rows);
        return this.assertRegionCount(tableName, 3);
    }

    private List<RegionInfo> assertRegionCount(TableName tableName, int nregions) throws Exception {
        UTIL.waitUntilNoRegionsInTransition();
        List tableRegions = admin.getRegions(tableName);
        Assert.assertEquals((long)nregions, (long)tableRegions.size());
        return tableRegions;
    }
}

