/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.TestMetaTableAccessor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionStateStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionStateStore.class);
    private static HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testVisitMetaForRegionExistingRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testVisitMetaForRegion");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForBadRegionState() throws Exception {
        TableName tableName = TableName.valueOf((String)"testVisitMetaForBadRegionState");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        Put put = new Put(regions.get(0).getRegionInfo().getRegionName(), EnvironmentEdgeManager.currentTime());
        put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)"BAD_STATE"));
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                Assert.assertNull((Object)state);
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForRegionNonExistingRegion() throws Exception {
        String encodedName = "fakeencodedregionname";
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion("fakeencodedregionname", new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                visitorCalled.set(true);
            }
        });
        Assert.assertFalse((String)"Visitor has been called, but it shouldn't.", (boolean)visitorCalled.get());
    }

    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionSplit() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)ThreadLocalRandom.current().nextLong());
        TableName tableName = this.name.getTableName();
        RegionInfo parent = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parent});
        MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)3);
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        regionStateStore.splitRegion(parent, splitA, splitB, serverName0, TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).build());
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 2);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 2);
        }
    }

    @Test
    public void testEmptyMetaDaughterLocationDuringSplit() throws IOException {
        TableName tableName = this.name.getTableName();
        long regionId = EnvironmentEdgeManager.currentTime();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)ThreadLocalRandom.current().nextLong());
        RegionInfo parent = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parent});
        MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)3);
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        regionStateStore.splitRegion(parent, splitA, splitB, serverName0, TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).build());
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            Get get1 = new Get(splitA.getRegionName());
            Result resultA = meta.get(get1);
            Cell serverCellA = resultA.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)splitA.getReplicaId()));
            Cell startCodeCellA = resultA.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)splitA.getReplicaId()));
            Assert.assertNull((Object)serverCellA);
            Assert.assertNull((Object)startCodeCellA);
            Get get2 = new Get(splitB.getRegionName());
            Result resultB = meta.get(get2);
            Cell serverCellB = resultB.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)splitB.getReplicaId()));
            Cell startCodeCellB = resultB.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)splitB.getReplicaId()));
            Assert.assertNull((Object)serverCellB);
            Assert.assertNull((Object)startCodeCellB);
        }
    }

    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionMerge() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)ThreadLocalRandom.current().nextLong());
        TableName tableName = this.name.getTableName();
        RegionInfo parentA = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo parentB = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo merged = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parentA, parentB});
            MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)3);
            regionStateStore.mergeRegions(merged, new RegionInfo[]{parentA, parentB}, serverName0, TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).build());
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMastersSystemTimeIsUsedInMergeRegions() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        TableName tableName = this.name.getTableName();
        RegionInfo regionInfoA = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(new byte[]{97}).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo regionInfoB = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(new byte[]{97}).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo mergedRegionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        ServerName sn = ServerName.valueOf((String)"bar", (int)0, (long)0L);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{regionInfoA, regionInfoB});
            MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)1);
            long serverNameTime = EnvironmentEdgeManager.currentTime() + 100000000L;
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation((Connection)UTIL.getConnection(), (RegionInfo)regionInfoA, (ServerName)sn, (long)1L, (long)serverNameTime);
            Get get = new Get(mergedRegionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertEquals((long)serverNameTime, (long)serverCell.getTimestamp());
            RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
            ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
            edge.setValue(masterSystemTime);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            try {
                regionStateStore.mergeRegions(mergedRegionInfo, new RegionInfo[]{regionInfoA, regionInfoB}, sn, TableDescriptorBuilder.newBuilder((TableName)tableName).build());
            }
            finally {
                EnvironmentEdgeManager.reset();
            }
            result = meta.get(get);
            serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getSeqNumColumn((int)0));
            Assert.assertNull((Object)serverCell);
            Assert.assertNull((Object)startCodeCell);
            Assert.assertNull((Object)seqNumCell);
        }
    }

    @Test
    public void testGetMergeRegions() throws Exception {
        TableName tn = this.name.getTableName();
        UTIL.createMultiRegionTable(tn, Bytes.toBytes((String)"CF"), 4);
        UTIL.waitTableAvailable(tn);
        Admin admin = UTIL.getAdmin();
        List regions = admin.getRegions(tn);
        Assert.assertEquals((long)4L, (long)regions.size());
        admin.mergeRegionsAsync((byte[][])new byte[][]{((RegionInfo)regions.get(0)).getRegionName(), ((RegionInfo)regions.get(1)).getRegionName()}, false).get(60L, TimeUnit.SECONDS);
        admin.mergeRegionsAsync((byte[][])new byte[][]{((RegionInfo)regions.get(2)).getRegionName(), ((RegionInfo)regions.get(3)).getRegionName()}, false).get(60L, TimeUnit.SECONDS);
        List mergedRegions = admin.getRegions(tn);
        Assert.assertEquals((long)2L, (long)mergedRegions.size());
        RegionInfo mergedRegion0 = (RegionInfo)mergedRegions.get(0);
        RegionInfo mergedRegion1 = (RegionInfo)mergedRegions.get(1);
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        List mergeParents = regionStateStore.getMergeRegions(mergedRegion0);
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(0)));
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(1)));
        mergeParents = regionStateStore.getMergeRegions(mergedRegion1);
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(2)));
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(3)));
        regionStateStore.deleteMergeQualifiers(mergedRegion0);
        mergeParents = regionStateStore.getMergeRegions(mergedRegion0);
        Assert.assertNull((Object)mergeParents);
        mergeParents = regionStateStore.getMergeRegions(mergedRegion1);
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(2)));
        Assert.assertTrue((boolean)mergeParents.contains(regions.get(3)));
    }

    @Test
    public void testAddMergeRegions() throws IOException {
        TableName tn = this.name.getTableName();
        Put put = new Put(Bytes.toBytes((String)this.name.getTableName().getNameAsString()));
        ArrayList<RegionInfo> ris = new ArrayList<RegionInfo>();
        int limit = 10;
        byte[] previous = HConstants.EMPTY_START_ROW;
        for (int i = 0; i < limit; ++i) {
            RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(previous).setEndKey(Bytes.toBytes((int)i)).build();
            ris.add(ri);
        }
        put = RegionStateStore.addMergeRegions((Put)put, ris);
        List cells = (List)put.getFamilyCellMap().get(HConstants.CATALOG_FAMILY);
        String previousQualifier = null;
        Assert.assertEquals((long)limit, (long)cells.size());
        for (Cell cell : cells) {
            String qualifier = Bytes.toString((byte[])cell.getQualifierArray());
            Assert.assertTrue((boolean)qualifier.startsWith("merge"));
            Assert.assertNotEquals((Object)qualifier, previousQualifier);
            previousQualifier = qualifier;
        }
    }

    @Test
    public void testMetaLocationForRegionReplicasIsRemovedAtTableDeletion() throws IOException {
        long regionId = EnvironmentEdgeManager.currentTime();
        TableName tableName = this.name.getTableName();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)3);
            RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
            regionStateStore.removeRegionReplicas(tableName, 3, 1);
            Get get = new Get(primary.getRegionName());
            Result result = meta.get(get);
            for (int replicaId = 0; replicaId < 3; ++replicaId) {
                Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerColumn((int)replicaId));
                Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getStartCodeColumn((int)replicaId));
                Cell stateCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getRegionStateColumn((int)replicaId));
                Cell snCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, CatalogFamilyFormat.getServerNameColumn((int)replicaId));
                if (replicaId == 0) {
                    Assert.assertNotNull((Object)stateCell);
                    continue;
                }
                Assert.assertNull((Object)serverCell);
                Assert.assertNull((Object)startCodeCell);
                Assert.assertNull((Object)stateCell);
                Assert.assertNull((Object)snCell);
            }
        }
    }
}

