/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.DummyRegionServerList;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.MockNoopMasterServices;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockMasterServices
extends MockNoopMasterServices {
    private final MasterFileSystem fileSystemManager;
    private final MasterWalManager walManager;
    private final SplitWALManager splitWALManager;
    private final AssignmentManager assignmentManager;
    private final TableStateManager tableStateManager;
    private final MasterRegion masterRegion;
    private MasterProcedureEnv procedureEnv;
    private ProcedureExecutor<MasterProcedureEnv> procedureExecutor;
    private ProcedureStore procedureStore;
    private final Connection connection;
    private final LoadBalancer balancer;
    private final ServerManager serverManager;
    private final ReplicationPeerManager rpm;
    private final ProcedureEvent<?> initialized = new ProcedureEvent((Object)"master initialized");
    public static final String DEFAULT_COLUMN_FAMILY_NAME = "cf";
    public static final ServerName MOCK_MASTER_SERVERNAME = ServerName.valueOf((String)"mockmaster.example.org", (int)1234, (long)-1L);

    public MockMasterServices(Configuration conf) throws IOException, ReplicationException {
        super(conf);
        Superusers.initialize((Configuration)conf);
        this.fileSystemManager = new MasterFileSystem(conf);
        this.walManager = new MasterWalManager((MasterServices)this);
        this.splitWALManager = conf.getBoolean("hbase.split.wal.zk.coordinated", false) ? null : new SplitWALManager((MasterServices)this);
        this.masterRegion = MasterRegionFactory.create((Server)this);
        this.assignmentManager = new AssignmentManager((MasterServices)this, this.masterRegion, (RegionStateStore)new MockRegionStateStore(this, this.masterRegion));
        this.balancer = LoadBalancerFactory.getLoadBalancer((Configuration)conf);
        this.serverManager = new ServerManager((MasterServices)this, (RegionServerList)new DummyRegionServerList());
        this.tableStateManager = (TableStateManager)Mockito.mock(TableStateManager.class);
        Mockito.when((Object)this.tableStateManager.getTableState((TableName)ArgumentMatchers.any())).thenReturn((Object)new TableState(TableName.valueOf((String)"AnyTableNameSetInMockMasterServcies"), TableState.State.ENABLED));
        ClientProtos.ClientService.BlockingInterface ri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
        builder.setProcessed(true);
        try {
            Mockito.when((Object)ri.mutate((RpcController)ArgumentMatchers.any(), (ClientProtos.MutateRequest)ArgumentMatchers.any())).thenReturn((Object)builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.handleRemoteException((Throwable)se);
        }
        try {
            Mockito.when((Object)ri.multi((RpcController)ArgumentMatchers.any(), (ClientProtos.MultiRequest)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<ClientProtos.MultiResponse>(){

                public ClientProtos.MultiResponse answer(InvocationOnMock invocation) throws Throwable {
                    return MockMasterServices.buildMultiResponse((ClientProtos.MultiRequest)invocation.getArgument(1));
                }
            });
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException((ServiceException)se);
        }
        this.connection = HConnectionTestingUtility.getMockedConnection(this.getConfiguration());
        Path rootdir = CommonFSUtils.getRootDir((Configuration)this.getConfiguration());
        CommonFSUtils.setRootDir((Configuration)this.getConfiguration(), (Path)rootdir);
        this.rpm = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        ReplicationQueueStorage rqs = (ReplicationQueueStorage)Mockito.mock(ReplicationQueueStorage.class);
        Mockito.when((Object)rqs.listAllQueueIds((ServerName)ArgumentMatchers.any(ServerName.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.rpm.getQueueStorage()).thenReturn((Object)rqs);
    }

    public void start(int numServes, RSProcedureDispatcher remoteDispatcher) throws IOException, KeeperException {
        this.startProcedureExecutor(remoteDispatcher);
        this.assignmentManager.start();
        for (int i = 0; i < numServes; ++i) {
            ServerName sn = ServerName.valueOf((String)"localhost", (int)(100 + i), (long)1L);
            this.serverManager.regionServerReport(sn, ServerMetricsBuilder.newBuilder((ServerName)sn).setLastReportTimestamp(EnvironmentEdgeManager.currentTime()).build());
        }
        ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).setEventReady(this.initialized, true);
    }

    public void restartRegionServer(ServerName serverName) throws IOException {
        List onlineServers = this.serverManager.getOnlineServersList();
        long startCode = -1L;
        for (ServerName s : onlineServers) {
            if (!s.getAddress().equals((Object)serverName.getAddress())) continue;
            startCode = s.getStartcode() + 1L;
            break;
        }
        if (startCode == -1L) {
            return;
        }
        ServerName sn = ServerName.valueOf((String)serverName.getAddress().toString(), (long)startCode);
        this.serverManager.regionServerReport(sn, ServerMetricsBuilder.newBuilder((ServerName)sn).setLastReportTimestamp(EnvironmentEdgeManager.currentTime()).build());
    }

    @Override
    public void stop(String why) {
        this.stopProcedureExecutor();
        this.assignmentManager.stop();
    }

    private void startProcedureExecutor(RSProcedureDispatcher remoteDispatcher) throws IOException {
        Configuration conf = this.getConfiguration();
        this.procedureStore = new NoopProcedureStore();
        this.procedureStore.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void abortProcess() {
                MockMasterServices.this.abort("The Procedure Store lost the lease", null);
            }
        });
        this.procedureEnv = new MasterProcedureEnv((MasterServices)this, remoteDispatcher != null ? remoteDispatcher : new RSProcedureDispatcher((MasterServices)this));
        this.procedureExecutor = new ProcedureExecutor(conf, (Object)this.procedureEnv, this.procedureStore, (ProcedureScheduler)this.procedureEnv.getProcedureScheduler());
        int numThreads = conf.getInt("hbase.master.procedure.threads", Math.max(Runtime.getRuntime().availableProcessors(), 16));
        boolean abortOnCorruption = conf.getBoolean("hbase.procedure.abort.on.corruption", false);
        this.procedureStore.start(numThreads);
        ProcedureTestingUtility.initAndStartWorkers(this.procedureExecutor, (int)numThreads, (boolean)abortOnCorruption);
        this.procedureEnv.getRemoteDispatcher().start();
    }

    private void stopProcedureExecutor() {
        if (this.procedureEnv != null) {
            this.procedureEnv.getRemoteDispatcher().stop();
        }
        if (this.procedureExecutor != null) {
            this.procedureExecutor.stop();
        }
        if (this.procedureStore != null) {
            this.procedureStore.stop(this.isAborted());
        }
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public ProcedureEvent<?> getInitializedEvent() {
        return this.initialized;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    @Override
    public MasterWalManager getMasterWalManager() {
        return this.walManager;
    }

    @Override
    public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return this.procedureExecutor;
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.balancer;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    @Override
    public TableStateManager getTableStateManager() {
        return this.tableStateManager;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ServerName getServerName() {
        return MOCK_MASTER_SERVERNAME;
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return super.getCoordinatedStateManager();
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return new TableDescriptors(){

            public TableDescriptor remove(TableName tablename) throws IOException {
                return null;
            }

            public Map<String, TableDescriptor> getAll() throws IOException {
                return null;
            }

            public TableDescriptor get(TableName tablename) throws IOException {
                TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tablename);
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)MockMasterServices.DEFAULT_COLUMN_FAMILY_NAME));
                return builder.build();
            }

            public Map<String, TableDescriptor> getByNamespace(String name) throws IOException {
                return null;
            }

            public void update(TableDescriptor htd, boolean cacheOnly) throws IOException {
            }
        };
    }

    private static ClientProtos.MultiResponse buildMultiResponse(ClientProtos.MultiRequest req) {
        ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        ClientProtos.ResultOrException.Builder roeBuilder = ClientProtos.ResultOrException.newBuilder();
        for (ClientProtos.RegionAction regionAction : req.getRegionActionList()) {
            regionActionResultBuilder.clear();
            for (ClientProtos.Action action : regionAction.getActionList()) {
                roeBuilder.clear();
                roeBuilder.setResult(ClientProtos.Result.getDefaultInstance());
                roeBuilder.setIndex(action.getIndex());
                regionActionResultBuilder.addResultOrException(roeBuilder.build());
            }
            builder.addRegionActionResult(regionActionResultBuilder.build());
        }
        return builder.build();
    }

    public SplitWALManager getSplitWALManager() {
        return this.splitWALManager;
    }

    @Override
    public ReplicationPeerManager getReplicationPeerManager() {
        return this.rpm;
    }

    private static class MockRegionStateStore
    extends RegionStateStore {
        public MockRegionStateStore(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        public void updateRegionLocation(RegionStateNode regionNode) throws IOException {
        }
    }
}

