/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMasterCoprocessorServices {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterCoprocessorServices.class);
    private MasterRpcServices masterServices;

    @Before
    public void setup() {
        this.masterServices = (MasterRpcServices)Mockito.mock(MasterRpcServices.class);
        Mockito.when((Object)this.masterServices.hasAccessControlServiceCoprocessor((MasterCoprocessorHost)ArgumentMatchers.any(MasterCoprocessorHost.class))).thenCallRealMethod();
        Mockito.when((Object)this.masterServices.hasVisibilityLabelsServiceCoprocessor((MasterCoprocessorHost)ArgumentMatchers.any(MasterCoprocessorHost.class))).thenCallRealMethod();
        Mockito.when((Object)this.masterServices.checkCoprocessorWithService((List)ArgumentMatchers.any(List.class), (Class)ArgumentMatchers.any(Class.class))).thenCallRealMethod();
    }

    @Test
    public void testAccessControlServices() {
        AccessController defaultImpl = new AccessController();
        MockAccessController customImpl = new MockAccessController();
        JMXListener unrelatedImpl = new JMXListener();
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(defaultImpl), AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(customImpl), AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(Collections.emptyList(), AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(null, AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(unrelatedImpl), AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Arrays.asList(unrelatedImpl, customImpl), AccessControlProtos.AccessControlService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Arrays.asList(unrelatedImpl, defaultImpl), AccessControlProtos.AccessControlService.Interface.class));
    }

    @Test
    public void testVisibilityLabelServices() {
        VisibilityController defaultImpl = new VisibilityController();
        MockVisibilityController customImpl = new MockVisibilityController();
        JMXListener unrelatedImpl = new JMXListener();
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(defaultImpl), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(customImpl), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(Collections.emptyList(), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(null, VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertFalse((boolean)this.masterServices.checkCoprocessorWithService(Collections.singletonList(unrelatedImpl), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Arrays.asList(unrelatedImpl, customImpl), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
        Assert.assertTrue((boolean)this.masterServices.checkCoprocessorWithService(Arrays.asList(unrelatedImpl, defaultImpl), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class));
    }

    private static class MockVisibilityController
    implements VisibilityLabelsProtos.VisibilityLabelsService.Interface,
    MasterCoprocessor,
    RegionCoprocessor,
    MasterObserver,
    RegionObserver {
        private MockVisibilityController() {
        }

        public void addLabels(RpcController controller, VisibilityLabelsProtos.VisibilityLabelsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        }

        public void setAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        }

        public void clearAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        }

        public void getAuths(RpcController controller, VisibilityLabelsProtos.GetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.GetAuthsResponse> done) {
        }

        public void listLabels(RpcController controller, VisibilityLabelsProtos.ListLabelsRequest request, RpcCallback<VisibilityLabelsProtos.ListLabelsResponse> done) {
        }
    }

    private static class MockAccessController
    implements AccessControlProtos.AccessControlService.Interface,
    MasterCoprocessor,
    RegionCoprocessor,
    MasterObserver,
    RegionObserver {
        private MockAccessController() {
        }

        public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        }

        public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        }

        public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        }

        public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        }

        public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        }
    }
}

