/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestBalancer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBalancer.class);
    private final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws Exception {
        this.TEST_UTIL.startMiniCluster();
    }

    @After
    public void after() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAssignmentsForBalancer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY, 10);
        TableName disableTableName = TableName.valueOf((String)"testDisableTable");
        this.TEST_UTIL.createMultiRegionTable(disableTableName, HConstants.CATALOG_FAMILY, 10);
        this.TEST_UTIL.getAdmin().disableTable(disableTableName);
        HMaster master = this.TEST_UTIL.getMiniHBaseCluster().getMaster();
        AssignmentManager assignmentManager = master.getAssignmentManager();
        RegionStates regionStates = assignmentManager.getRegionStates();
        ServerName sn1 = ServerName.parseServerName((String)"asf903.gq1.ygridcore.net,52690,1517835491385");
        regionStates.getOrCreateServer(sn1);
        TableStateManager tableStateManager = master.getTableStateManager();
        ServerManager serverManager = master.getServerManager();
        Map assignments = assignmentManager.getRegionStates().getAssignmentsForBalancer(tableStateManager, serverManager.getOnlineServersList());
        Assert.assertFalse((boolean)assignments.containsKey(disableTableName));
        Assert.assertTrue((boolean)assignments.containsKey(tableName));
        Assert.assertFalse((boolean)((Map)assignments.get(tableName)).containsKey(sn1));
    }
}

