/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestVerifyBucketCacheFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyBucketCacheFile.class);
    @Parameterized.Parameter(value=0)
    public int constructedBlockSize;
    @Parameterized.Parameter(value=1)
    public int[] constructedBlockSizes;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;

    @Parameterized.Parameters(name="{index}: blockSize={0}, bucketSizes={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({8192, null}, {16384, new int[]{3072, 5120, 9216, 17408, 29696, 33792, 66560, 99328, 132096}});
    }

    @Test
    public void testRetrieveFromFile() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertEquals((long)0L, (long)usedSize);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        bucketCache.shutdown();
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)usedSize, (long)bucketCache.getAllocator().getUsedSize());
        bucketCache.shutdown();
        java.nio.file.Path cacheFile = FileSystems.getDefault().getPath(testDir.toString(), "bucket.cache");
        Assert.assertTrue((boolean)Files.deleteIfExists(cacheFile));
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        for (CacheTestUtils.HFileBlockPair block : blocks) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        bucketCache.shutdown();
        java.nio.file.Path mapFile = FileSystems.getDefault().getPath(testDir.toString(), "bucket.persistence");
        Assert.assertTrue((boolean)Files.deleteIfExists(mapFile));
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testRetrieveFromFileAfterDelete() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", 300L);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertEquals((long)0L, (long)usedSize);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        bucketCache.shutdown();
        java.nio.file.Path mapFile = FileSystems.getDefault().getPath(testDir.toString(), "bucket.persistence");
        Assert.assertTrue((boolean)Files.deleteIfExists(mapFile));
        Thread.sleep(350L);
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence", 60000, conf);
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
    }

    @Test
    public void testModifiedBucketCacheFileData() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertEquals((long)0L, (long)usedSize);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        bucketCache.shutdown();
        String file = testDir + "/bucket.cache";
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, false)));){
            out.write("test bucket cache");
        }
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testModifiedBucketCacheFileTime() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertEquals((long)0L, (long)usedSize);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(this.constructedBlockSize, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        bucketCache.shutdown();
        java.nio.file.Path file = FileSystems.getDefault().getPath(testDir.toString(), "bucket.cache");
        Files.setLastModifiedTime(file, FileTime.from(Instant.now().plusMillis(1000L)));
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    private void waitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey) throws InterruptedException {
        while (!cache.backingMap.containsKey(cacheKey) || cache.ramCache.containsKey(cacheKey)) {
            Thread.sleep(100L);
        }
    }

    private void cacheAndWaitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey, Cacheable block) throws InterruptedException {
        cache.cacheBlock(cacheKey, block);
        this.waitUntilFlushedToBucket(cache, cacheKey);
    }
}

