/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={IOTests.class, MediumTests.class})
public class TestBucketCachePersister {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBucketCachePersister.class);
    public TestName name = new TestName();
    public int constructedBlockSize = 16384;
    public int[] constructedBlockSizes = new int[]{3072, 5120, 9216, 17408, 29696, 33792, 66560, 99328, 132096};
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 1000;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;
    Path testDir;

    public Configuration setupBucketCacheConfig(long bucketCachePersistInterval) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(this.testDir);
        conf.setLong("hbase.bucketcache.persist.intervalinmillis", bucketCachePersistInterval);
        return conf;
    }

    public BucketCache setupBucketCache(Configuration conf) throws IOException {
        conf.set("hbase.prefetch.file.list.path", this.testDir + "/prefetch.persistence");
        BucketCache bucketCache = new BucketCache("file:" + this.testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, this.testDir + "/bucket.persistence", 60000, conf);
        return bucketCache;
    }

    public void cleanupBucketCache(BucketCache bucketCache) throws IOException {
        bucketCache.shutdown();
        TEST_UTIL.cleanupDataTestDirOnTestFS(String.valueOf(this.testDir));
        Assert.assertFalse((boolean)TEST_UTIL.getTestFileSystem().exists(this.testDir));
    }

    @Test
    public void testPrefetchPersistenceCrash() throws Exception {
        long bucketCachePersistInterval = 3000L;
        Configuration conf = this.setupBucketCacheConfig(bucketCachePersistInterval);
        BucketCache bucketCache = this.setupBucketCache(conf);
        CacheConfig cacheConf = new CacheConfig(conf, (BlockCache)bucketCache);
        FileSystem fs = HFileSystem.get((Configuration)conf);
        Path storeFile = this.writeStoreFile("TestPrefetch0", conf, cacheConf, fs);
        Path storeFile2 = this.writeStoreFile("TestPrefetch1", conf, cacheConf, fs);
        this.readStoreFile(storeFile, 0L, fs, cacheConf, conf, bucketCache);
        this.readStoreFile(storeFile2, 0L, fs, cacheConf, conf, bucketCache);
        Thread.sleep(bucketCachePersistInterval);
        Assert.assertTrue((boolean)new File(this.testDir + "/prefetch.persistence").exists());
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.persistence").exists());
        Assert.assertTrue((boolean)new File(this.testDir + "/prefetch.persistence").delete());
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.persistence").delete());
        this.cleanupBucketCache(bucketCache);
    }

    @Test
    public void testPrefetchPersistenceCrashNegative() throws Exception {
        long bucketCachePersistInterval = Long.MAX_VALUE;
        Configuration conf = this.setupBucketCacheConfig(bucketCachePersistInterval);
        BucketCache bucketCache = this.setupBucketCache(conf);
        CacheConfig cacheConf = new CacheConfig(conf, (BlockCache)bucketCache);
        FileSystem fs = HFileSystem.get((Configuration)conf);
        Path storeFile = this.writeStoreFile("TestPrefetch2", conf, cacheConf, fs);
        this.readStoreFile(storeFile, 0L, fs, cacheConf, conf, bucketCache);
        Assert.assertFalse((boolean)new File(this.testDir + "/prefetch.persistence").exists());
        Assert.assertFalse((boolean)new File(this.testDir + "/bucket.persistence").exists());
        this.cleanupBucketCache(bucketCache);
    }

    @Test
    public void testPrefetchListUponBlockEviction() throws Exception {
        Configuration conf = this.setupBucketCacheConfig(200L);
        BucketCache bucketCache1 = this.setupBucketCache(conf);
        CacheConfig cacheConf = new CacheConfig(conf, (BlockCache)bucketCache1);
        FileSystem fs = HFileSystem.get((Configuration)conf);
        Path storeFile = this.writeStoreFile("TestPrefetch3", conf, cacheConf, fs);
        this.readStoreFile(storeFile, 0L, fs, cacheConf, conf, bucketCache1);
        Thread.sleep(500L);
        BlockCacheKey bucketCacheKey = (BlockCacheKey)bucketCache1.backingMap.entrySet().iterator().next().getKey();
        Assert.assertTrue((boolean)PrefetchExecutor.isFilePrefetched((String)storeFile.getName()));
        bucketCache1.evictBlock(bucketCacheKey);
        Assert.assertFalse((boolean)PrefetchExecutor.isFilePrefetched((String)storeFile.getName()));
    }

    public void readStoreFile(Path storeFilePath, long offset, FileSystem fs, CacheConfig cacheConf, Configuration conf, BucketCache bucketCache) throws Exception {
        boolean isCached;
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)storeFilePath, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        while (!reader.prefetchComplete()) {
            Thread.sleep(1000L);
        }
        HFileBlock block = reader.readBlock(offset, -1L, false, true, false, true, null, null);
        BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
        BucketEntry be = (BucketEntry)bucketCache.backingMap.get(blockCacheKey);
        boolean bl = isCached = bucketCache.getBlock(blockCacheKey, true, false, true) != null;
        if (block.getBlockType() == BlockType.DATA || block.getBlockType() == BlockType.ROOT_INDEX || block.getBlockType() == BlockType.INTERMEDIATE_INDEX) {
            Assert.assertTrue((boolean)isCached);
        }
    }

    public Path writeStoreFile(String fname, Configuration conf, CacheConfig cacheConf, FileSystem fs) throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), fname);
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(conf, cacheConf, fs).withOutputDir(storeFileParentDir).withFileContext(meta).build();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int rowLen = 32;
        for (int i = 0; i < 1000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] v = RandomKeyValueUtil.randomValue(rand);
            int cfLen = ((Random)rand).nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, ((Random)rand).nextLong(), TestBucketCachePersister.generateKeyType(rand), v, 0, v.length);
            sfw.append((Cell)kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }
}

