/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, SmallTests.class})
public class TestScannerSelectionUsingKeyRange {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerSelectionUsingKeyRange.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static TableName TABLE = TableName.valueOf((String)"myTable");
    private static String FAMILY = "myCF";
    private static byte[] FAMILY_BYTES = Bytes.toBytes((String)FAMILY);
    private static final int NUM_ROWS = 8;
    private static final int NUM_COLS_PER_ROW = 5;
    private static final int NUM_FILES = 2;
    private static final Map<Object, Integer> TYPE_COUNT = new HashMap<Object, Integer>(3);
    private BloomType bloomType;
    private int expectedCount;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object type : TYPE_COUNT.keySet()) {
            params.add(new Object[]{type, TYPE_COUNT.get(type)});
        }
        return params;
    }

    public TestScannerSelectionUsingKeyRange(Object type, Object count) {
        this.bloomType = (BloomType)type;
        this.expectedCount = (Integer)count;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testScannerSelection() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.compactionThreshold", 10000);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_BYTES).setBlockCacheEnabled(true).setBloomFilterType(this.bloomType).build()).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)TABLE).build();
        HRegion region = HBaseTestingUtil.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(), conf, tableDescriptor);
        for (int iFile = 0; iFile < 2; ++iFile) {
            for (int iRow = 0; iRow < 8; ++iRow) {
                Put put = new Put(Bytes.toBytes((String)("row" + iRow)));
                for (int iCol = 0; iCol < 5; ++iCol) {
                    put.addColumn(FAMILY_BYTES, Bytes.toBytes((String)("col" + iCol)), Bytes.toBytes((String)("value" + iFile + "_" + iRow + "_" + iCol)));
                }
                region.put(put);
            }
            region.flush(true);
        }
        Scan scan = new Scan().withStartRow(Bytes.toBytes((String)"aaa")).withStopRow(Bytes.toBytes((String)"aaz"));
        BlockCache cache = BlockCacheFactory.createBlockCache((Configuration)conf);
        RegionScannerImpl scanner = region.getScanner(scan);
        ArrayList results = new ArrayList();
        while (scanner.next(results)) {
        }
        scanner.close();
        Assert.assertEquals((long)0L, (long)results.size());
        if (cache instanceof LruBlockCache) {
            SortedSet accessedFiles = ((LruBlockCache)cache).getCachedFileNamesForTest();
            Assert.assertEquals((long)this.expectedCount, (long)accessedFiles.size());
        }
        HBaseTestingUtil.closeRegionAndWAL(region);
    }

    static {
        TYPE_COUNT.put(BloomType.ROWCOL, 0);
        TYPE_COUNT.put(BloomType.ROW, 0);
        TYPE_COUNT.put(BloomType.NONE, 0);
    }
}

