/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, LargeTests.class})
public class TestPrefetchRSClose {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPrefetchRSClose.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestPrefetchRSClose.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private Configuration conf;
    Path testDir;
    MiniZooKeeperCluster zkCluster;
    SingleProcessHBaseCluster cluster;
    StartTestingClusterOption option = StartTestingClusterOption.builder().numRegionServers(2).build();

    @Before
    public void setup() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(this.testDir);
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.conf.set("hbase.bucketcache.ioengine", "file:" + this.testDir + "/bucket.cache");
        this.conf.setInt("hbase.bucketcache.size", 400);
        this.conf.set("hbase.bucketcache.persistent.path", this.testDir + "/bucket.persistence");
        this.conf.set("hbase.prefetch.file.list.path", this.testDir + "/prefetch.persistence");
        this.zkCluster = TEST_UTIL.startMiniZKCluster();
        this.cluster = TEST_UTIL.startMiniHBaseCluster(this.option);
        Assert.assertEquals((long)2L, (long)this.cluster.getRegionServerThreads().size());
        this.cluster.setConf(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefetchPersistence() throws Exception {
        TableName tableName = TableName.valueOf((String)"table1");
        byte[] row0 = Bytes.toBytes((String)"row1");
        byte[] row1 = Bytes.toBytes((String)"row2");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qf1 = Bytes.toBytes((String)"qf1");
        byte[] qf2 = Bytes.toBytes((String)"qf2");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        Table table = TEST_UTIL.createTable(td, (byte[][])null);
        try {
            Put put0 = new Put(row0);
            put0.addColumn(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row1);
            put1.addColumn(family, qf2, 1L, value2);
            table.put(put1);
            TEST_UTIL.flush(tableName);
        }
        finally {
            Thread.sleep(2000L);
        }
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.persistence").exists());
        Assert.assertTrue((boolean)new File(this.testDir + "/prefetch.persistence").exists());
        this.cluster.stopRegionServer(0);
        LOG.info("Stopped Region Server 0.");
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.persistence").exists());
        Assert.assertTrue((boolean)new File(this.testDir + "/prefetch.persistence").exists());
        this.cluster.startRegionServer();
        Assert.assertFalse((boolean)new File(this.testDir + "/prefetch.persistence").exists());
        Assert.assertFalse((boolean)new File(this.testDir + "/bucket.persistence").exists());
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.cleanupDataTestDirOnTestFS(String.valueOf(this.testDir));
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
        }
    }
}

