/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.RedundantKVGenerator;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileTestBase {
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static final Logger LOG = LoggerFactory.getLogger(HFileTestBase.class);
    protected static FileSystem FS;

    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        FS = FileSystem.get((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(Configuration conf, Path path, Compression.Algorithm compression) throws Exception {
        RedundantKVGenerator generator = new RedundantKVGenerator();
        List testKvs = generator.generateTestKeyValues(10000);
        CacheConfig cacheConf = new CacheConfig(conf);
        HFileContext fileContext = new HFileContextBuilder().withBlockSize(4096).withCompression(compression).build();
        LOG.info("Writing with " + fileContext);
        FSDataOutputStream out = FS.create(path);
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(out).withFileContext(fileContext).create();
        try {
            for (KeyValue kv : testKvs) {
                writer.append((Cell)kv);
            }
        }
        finally {
            writer.close();
            out.close();
        }
        LOG.info("Reading with " + fileContext);
        int i = 0;
        HFileScanner scanner = null;
        HFile.Reader reader = HFile.createReader((FileSystem)FS, (Path)path, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        try {
            scanner = reader.getScanner(conf, false, false);
            Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
            do {
                Cell kv = scanner.getCell();
                Assert.assertTrue((String)"Read back an unexpected or invalid KV", (boolean)testKvs.contains(KeyValueUtil.ensureKeyValue((Cell)kv)));
                ++i;
            } while (scanner.next());
        }
        finally {
            reader.close();
            scanner.close();
        }
        Assert.assertEquals((String)"Did not read back as many KVs as written", (long)i, (long)testKvs.size());
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        LOG.info("Random seeking with " + fileContext);
        reader = HFile.createReader((FileSystem)FS, (Path)path, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        try {
            scanner = reader.getScanner(conf, false, true);
            Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
            for (i = 0; i < 100; ++i) {
                KeyValue kv = (KeyValue)testKvs.get(((Random)rand).nextInt(testKvs.size()));
                Assert.assertEquals((String)("Unable to find KV as expected: " + kv), (long)0L, (long)scanner.seekTo((Cell)kv));
            }
        }
        finally {
            scanner.close();
            reader.close();
        }
    }
}

