/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALCoprocessor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestWALObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALObserver.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALObserver.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observedTable");
    private static byte[][] TEST_FAMILY = new byte[][]{Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam2"), Bytes.toBytes((String)"fam3")};
    private static byte[][] TEST_QUALIFIER = new byte[][]{Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"q3")};
    private static byte[][] TEST_VALUE = new byte[][]{Bytes.toBytes((String)"v1"), Bytes.toBytes((String)"v2"), Bytes.toBytes((String)"v3")};
    private static byte[] TEST_ROW = Bytes.toBytes((String)"testRow");
    @Rule
    public TestName currentTest = new TestName();
    private Configuration conf;
    private FileSystem fs;
    private Path hbaseRootDir;
    private Path hbaseWALRootDir;
    private Path oldLogDir;
    private Path logDir;
    private WALFactory wals;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.wal.classes", new String[]{SampleRegionWALCoprocessor.class.getName()});
        conf.set("hbase.coprocessor.region.classes", SampleRegionWALCoprocessor.class.getName());
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(1);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        Path hbaseWALRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbaseLogRoot"));
        LOG.info("hbase.rootdir=" + hbaseRootDir);
        CommonFSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
        CommonFSUtils.setWALRootDir((Configuration)conf, (Path)hbaseWALRootDir);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        this.hbaseWALRootDir = CommonFSUtils.getWALRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.hbaseWALRootDir, "oldWALs");
        String serverName = ServerName.valueOf((String)this.currentTest.getMethodName(), (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString();
        this.logDir = new Path(this.hbaseWALRootDir, AbstractFSWALProvider.getWALDirectoryName((String)serverName));
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseWALRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
        }
        this.wals = new WALFactory(this.conf, serverName);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.wals.shutdown();
        }
        catch (IOException exception) {
            LOG.warn("Ignoring failure to close wal factory. " + exception.getMessage());
            LOG.debug("details of failure to close wal factory.", (Throwable)exception);
        }
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
    }

    @Test
    public void testWALObserverWriteToWAL() throws Exception {
        WAL log = this.wals.getWAL(null);
        this.verifyWritesSeen(log, this.getCoprocessor(log, SampleRegionWALCoprocessor.class), false);
    }

    private void verifyWritesSeen(WAL log, SampleRegionWALCoprocessor cp, boolean seesLegacy) throws Exception {
        RegionInfo hri = this.createBasicHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        TableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        Path basedir = new Path(this.hbaseRootDir, Bytes.toString((byte[])TEST_TABLE));
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        cp.setTestValues(TEST_TABLE, TEST_ROW, TEST_FAMILY[0], TEST_QUALIFIER[0], TEST_FAMILY[1], TEST_QUALIFIER[1], TEST_FAMILY[2], TEST_QUALIFIER[2]);
        Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
        Put p = this.creatPutWith2Families(TEST_ROW);
        NavigableMap familyMap = p.getFamilyCellMap();
        WALEdit edit = new WALEdit();
        edit.add((Map)familyMap);
        boolean foundFamily0 = false;
        boolean foundFamily2 = false;
        boolean modifiedFamily1 = false;
        ArrayList cells = edit.getCells();
        for (Cell cell : cells) {
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[1]) || Arrays.equals(CellUtil.cloneValue((Cell)cell), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertTrue((boolean)foundFamily0);
        Assert.assertFalse((boolean)foundFamily2);
        Assert.assertFalse((boolean)modifiedFamily1);
        long now = EnvironmentEdgeManager.currentTime();
        long txid = log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), hri.getTable(), now, new MultiVersionConcurrencyControl(), scopes), edit);
        log.sync(txid);
        foundFamily0 = false;
        foundFamily2 = false;
        modifiedFamily1 = false;
        for (Cell cell : cells) {
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[1]) || Arrays.equals(CellUtil.cloneValue((Cell)cell), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertFalse((boolean)foundFamily0);
        Assert.assertTrue((boolean)foundFamily2);
        Assert.assertTrue((boolean)modifiedFamily1);
        Assert.assertTrue((boolean)cp.isPreWALWriteCalled());
        Assert.assertTrue((boolean)cp.isPostWALWriteCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyWALEditAreNotSeen() throws Exception {
        RegionInfo hri = this.createBasicHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        TableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        try (WAL log = this.wals.getWAL(null);){
            SampleRegionWALCoprocessor cp = this.getCoprocessor(log, SampleRegionWALCoprocessor.class);
            cp.setTestValues(TEST_TABLE, null, null, null, null, null, null, null);
            Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
            long now = EnvironmentEdgeManager.currentTime();
            long txid = log.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), hri.getTable(), now, mvcc, scopes), new WALEdit());
            log.sync(txid);
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPostWALWriteCalled());
        }
    }

    @Test
    public void testWALCoprocessorReplay() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        final TableDescriptor htd = this.getBasic3FamilyHTableDescriptor(tableName);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        Path basedir = CommonFSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        WAL wal = this.wals.getWAL(null);
        WALEdit edit = new WALEdit();
        long now = EnvironmentEdgeManager.currentTime();
        int countPerFamily = 1000;
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        for (byte[] fam : htd.getColumnFamilyNames()) {
            this.addWALEdits(tableName, hri, TEST_ROW, fam, 1000, EnvironmentEdgeManager.getDelegate(), wal, scopes, mvcc);
        }
        wal.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes), edit);
        wal.sync();
        User user = HBaseTestingUtil.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Path p = TestWALObserver.this.runWALSplit(newConf);
                LOG.info("WALSplit path == " + p);
                WALFactory wals2 = new WALFactory(TestWALObserver.this.conf, ServerName.valueOf((String)(TestWALObserver.this.currentTest.getMethodName() + "2"), (int)16010, (long)EnvironmentEdgeManager.currentTime()).toString());
                WAL wal2 = wals2.getWAL(null);
                HRegion region = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALObserver.this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2, (RegionServerServices)TEST_UTIL.getHBaseCluster().getRegionServer(0), null);
                SampleRegionWALCoprocessor cp2 = (SampleRegionWALCoprocessor)region.getCoprocessorHost().findCoprocessor(SampleRegionWALCoprocessor.class);
                Assert.assertNotNull((Object)cp2);
                Assert.assertTrue((boolean)cp2.isPreWALRestoreCalled());
                Assert.assertTrue((boolean)cp2.isPostWALRestoreCalled());
                region.close();
                wals2.close();
                return null;
            }
        });
    }

    @Test
    public void testWALObserverLoaded() throws Exception {
        WAL log = this.wals.getWAL(null);
        Assert.assertNotNull((Object)this.getCoprocessor(log, SampleRegionWALCoprocessor.class));
    }

    @Test
    public void testWALObserverRoll() throws Exception {
        WAL wal = this.wals.getWAL(null);
        SampleRegionWALCoprocessor cp = this.getCoprocessor(wal, SampleRegionWALCoprocessor.class);
        cp.setTestValues(TEST_TABLE, null, null, null, null, null, null, null);
        Assert.assertFalse((boolean)cp.isPreWALRollCalled());
        Assert.assertFalse((boolean)cp.isPostWALRollCalled());
        wal.rollWriter(true);
        Assert.assertTrue((boolean)cp.isPreWALRollCalled());
        Assert.assertTrue((boolean)cp.isPostWALRollCalled());
    }

    private SampleRegionWALCoprocessor getCoprocessor(WAL wal, Class<? extends SampleRegionWALCoprocessor> clazz) throws Exception {
        WALCoprocessorHost host = wal.getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(clazz.getName());
        return (SampleRegionWALCoprocessor)c;
    }

    private RegionInfo createBasicHRegionInfo(String tableName) {
        return RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build();
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private Put creatPutWith2Families(byte[] row) throws IOException {
        Put p = new Put(row);
        for (int i = 0; i < TEST_FAMILY.length - 1; ++i) {
            p.addColumn(TEST_FAMILY[i], TEST_QUALIFIER[i], TEST_VALUE[i]);
        }
        return p;
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = WALSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c, (WALFactory)this.wals);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info("Split file=" + splits.get(0));
        return (Path)splits.get(0);
    }

    private void addWALEdits(TableName tableName, RegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, WAL wal, NavigableMap<byte[], Integer> scopes, MultiVersionConcurrencyControl mvcc) throws IOException {
        String familyStr = Bytes.toString((byte[])family);
        long txid = -1L;
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes((String)(familyStr + ":" + Integer.toString(j)));
            WALEdit edit = new WALEdit();
            edit.add((Cell)new KeyValue(rowName, family, qualifierBytes, ee.currentTime(), columnBytes));
            txid = wal.appendData(hri, new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, ee.currentTime(), mvcc), edit);
        }
        if (-1L != txid) {
            wal.sync(txid);
        }
    }

    private TableDescriptor getBasic3FamilyHTableDescriptor(TableName tableName) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        Arrays.stream(TEST_FAMILY).map(ColumnFamilyDescriptorBuilder::of).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    private TableDescriptor createBasic3FamilyHTD(String tableName) {
        return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"a")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"b")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"c")).build();
    }
}

