/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.RequestTooBigException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRequestTooBigException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRequestTooBigException.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName NAME = TableName.valueOf((String)"request_too_big");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static Table TABLE;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.max.request.size", 10240);
        TEST_UTIL.startMiniCluster(1);
        TABLE = TEST_UTIL.createTable(NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)TABLE, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHbasePutDeleteCell() throws Exception {
        byte[] value = new byte[1024];
        Bytes.random((byte[])value);
        for (int m = 0; m < 100; ++m) {
            Put p = new Put(Bytes.toBytes((String)("bigrow-" + m)));
            for (int i = 0; i < 100; ++i) {
                p.addColumn(FAMILY, Bytes.toBytes((String)("someQualifier" + i)), value);
            }
            Put finalPut = p;
            Assert.assertThrows(RequestTooBigException.class, () -> TABLE.put(finalPut));
        }
    }
}

