/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestScannersFromClientSide;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestIntraRowPagination {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIntraRowPagination.class);
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanLimitAndOffset() throws Exception {
        byte[][] ROWS = HTestConst.makeNAscii(HTestConst.DEFAULT_ROW_BYTES, 2);
        byte[][] FAMILIES = HTestConst.makeNAscii(HTestConst.DEFAULT_CF_BYTES, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(HTestConst.DEFAULT_QUALIFIER_BYTES, 10);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])HTestConst.DEFAULT_TABLE_BYTES));
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)HTestConst.DEFAULT_TABLE).build();
        for (byte[] family : FAMILIES) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        HRegion region = HBaseTestingUtil.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), builder.build());
        try {
            boolean toLog = true;
            ArrayList<Cell> kvListExp = new ArrayList<Cell>();
            int storeOffset = 1;
            int storeLimit = 3;
            for (int r = 0; r < ROWS.length; ++r) {
                Put put = new Put(ROWS[r]);
                for (int c = 0; c < FAMILIES.length; ++c) {
                    for (int q = 0; q < QUALIFIERS.length; ++q) {
                        KeyValue kv = new KeyValue(ROWS[r], FAMILIES[c], QUALIFIERS[q], 1L, HTestConst.DEFAULT_VALUE_BYTES);
                        put.add((Cell)kv);
                        if (storeOffset > q || q >= storeOffset + storeLimit) continue;
                        kvListExp.add((Cell)kv);
                    }
                }
                region.put(put);
            }
            Scan scan = new Scan();
            scan.setRowOffsetPerColumnFamily(storeOffset);
            scan.setMaxResultsPerColumnFamily(storeLimit);
            RegionScannerImpl scanner = region.getScanner(scan);
            ArrayList kvListScan = new ArrayList();
            ArrayList results = new ArrayList();
            while (scanner.next(results) || !results.isEmpty()) {
                kvListScan.addAll(results);
                results.clear();
            }
            Result result = Result.create(kvListScan);
            TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan with storeOffset and storeLimit");
        }
        finally {
            HBaseTestingUtil.closeRegionAndWAL(region);
        }
    }
}

