/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SleepAtFirstRpcCall;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestFromClientSide;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestIncrementsFromClientSide {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIncrementsFromClientSide.class);
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    protected static int SLAVES = 1;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MultiRowMutationEndpoint.class.getName()});
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDuplicateIncrement() throws Exception {
        TableDescriptorBuilder builder = TEST_UTIL.createModifyableTableDescriptor(this.name.getMethodName());
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("hbase.coprocessor.SleepAtFirstRpcCall.sleepTime", "2000");
        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)SleepAtFirstRpcCall.class.getName()).setPriority(1).setProperties(kvs).build());
        TEST_UTIL.createTable(builder.build(), (byte[][])new byte[][]{ROW}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 50);
        c.setInt("hbase.rpc.timeout", 1500);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)c);
             Table table = connection.getTableBuilder(TableName.valueOf((String)this.name.getMethodName()), null).setOperationTimeout(3000).build();){
            Increment inc = new Increment(ROW);
            inc.addColumn(HBaseTestingUtil.fam1, QUALIFIER, 1L);
            Result result = table.increment(inc);
            Cell[] cells = result.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            TestIncrementsFromClientSide.assertIncrementKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, 1L);
            Result readResult = table.get(new Get(ROW));
            cells = readResult.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            TestIncrementsFromClientSide.assertIncrementKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, 1L);
        }
    }

    @Test
    public void testDuplicateBatchIncrement() throws Exception {
        TableDescriptorBuilder builder = TEST_UTIL.createModifyableTableDescriptor(this.name.getMethodName());
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("hbase.coprocessor.SleepAtFirstRpcCall.sleepTime", "2000");
        builder.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)SleepAtFirstRpcCall.class.getName()).setPriority(1).setProperties(kvs).build());
        TEST_UTIL.createTable(builder.build(), (byte[][])new byte[][]{ROW}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 50);
        c.setInt("hbase.rpc.timeout", 1500);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)c);
             Table table = connection.getTableBuilder(TableName.valueOf((String)this.name.getMethodName()), null).setOperationTimeout(3000).build();){
            Increment inc = new Increment(ROW);
            inc.addColumn(HBaseTestingUtil.fam1, QUALIFIER, 1L);
            Object[] results = new Object[1];
            table.batch(Collections.singletonList(inc), results);
            Cell[] cells = ((Result)results[0]).rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            TestIncrementsFromClientSide.assertIncrementKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, 1L);
            Result readResult = table.get(new Get(ROW));
            cells = readResult.rawCells();
            Assert.assertEquals((long)1L, (long)cells.length);
            TestIncrementsFromClientSide.assertIncrementKey(cells[0], ROW, HBaseTestingUtil.fam1, QUALIFIER, 1L);
        }
    }

    @Test
    public void testIncrementWithDeletes() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        TEST_UTIL.flush(TABLENAME);
        Delete del = new Delete(ROW);
        ht.delete(del);
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, COLUMN)));
    }

    @Test
    public void testIncrementingInvalidValue() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        Put p = new Put(ROW);
        p.addColumn(FAMILY, COLUMN, Bytes.toBytes((int)5));
        ht.put(p);
        try {
            ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, COLUMN, 5L);
        try {
            ht.increment(inc);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchIncrementsWithReturnResultFalse() throws Exception {
        this.LOG.info("Starting testBatchIncrementsWithReturnResultFalse");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, FAMILY);
        Increment inc1 = new Increment(Bytes.toBytes((String)"row2"));
        inc1.setReturnResults(false);
        inc1.addColumn(FAMILY, Bytes.toBytes((String)"f1"), 1L);
        Increment inc2 = new Increment(Bytes.toBytes((String)"row2"));
        inc2.setReturnResults(false);
        inc2.addColumn(FAMILY, Bytes.toBytes((String)"f1"), 1L);
        ArrayList<Increment> incs = new ArrayList<Increment>();
        incs.add(inc1);
        incs.add(inc2);
        Object[] results = new Object[2];
        table.batch(incs, results);
        Assert.assertTrue((results.length == 2 ? 1 : 0) != 0);
        for (Object r : results) {
            Result result = (Result)r;
            Assert.assertTrue((boolean)result.isEmpty());
        }
        table.close();
    }

    @Test
    public void testIncrementInvalidArguments() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        try {
            ht.incrementColumnValue(null, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown NPE/IOE");
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        try {
            ht.incrementColumnValue(ROW, null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown NPE/IOE");
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        try {
            Increment incNoRow = new Increment((byte[])null);
            incNoRow.addColumn(FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IAE/NPE");
        }
        catch (IllegalArgumentException | NullPointerException incNoRow) {
            // empty catch block
        }
        try {
            Increment incNoFamily = new Increment(ROW);
            incNoFamily.addColumn(null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementOutOfOrder() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"B"), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
    }

    @Test
    public void testIncrementOnSameColumn() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        byte[] TABLENAME = Bytes.toBytes((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TableName.valueOf((byte[])TABLENAME), FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
        ht.close();
    }

    @Test
    public void testIncrementIncrZeroAtFirst() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, col1, 0L);
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)1L, (long)kvs.length);
        Assert.assertNotNull((Object)kvs[0]);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, col1, 0L);
        inc = new Increment(ROW);
        inc.addColumn(FAMILY, col1, 1L);
        inc.addColumn(FAMILY, col2, 0L);
        inc.addColumn(FAMILY, col3, 2L);
        ht.increment(inc);
        get = new Get(ROW);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        Assert.assertNotNull((Object)kvs[0]);
        Assert.assertNotNull((Object)kvs[1]);
        Assert.assertNotNull((Object)kvs[2]);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, col1, 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, col2, 0L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, col3, 2L);
    }

    @Test
    public void testIncrement() throws Exception {
        int i;
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName TABLENAME = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[0], 1L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[1], 2L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[2], 3L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[3], 4L);
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, QUALIFIERS[1], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[3], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[4], 1L);
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)5L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 3L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 5L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[4], ROW, FAMILY, QUALIFIERS[4], 1L);
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        get = new Get(ROWS[0]);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], i + 1);
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 0L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
    }

    @Test
    public void testIncrementWithCustomTimestamp() throws IOException {
        TableName TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(TABLENAME, FAMILY);
        long timestamp = 999L;
        Increment increment = new Increment(ROW);
        increment.add((Cell)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(ROW).setFamily(FAMILY).setQualifier(QUALIFIER).setTimestamp(timestamp).setType(KeyValue.Type.Put.getCode()).setValue(Bytes.toBytes((long)100L)).build());
        Result r = table.increment(increment);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.get(new Get(ROW));
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.increment(increment);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertNotEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.get(new Get(ROW));
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertNotEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
    }

    static void assertIncrementKey(Cell key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        TestFromClientSide.assertIncrementKey(key, row, family, qualifier, value);
    }

    public static String filterStringSoTableNameSafe(String str) {
        return str.replaceAll("\\[fast\\=(.*)\\]", ".FAST.is.$1");
    }

    @Test
    public void testIncrementWithTtlTags() throws Exception {
        this.LOG.info("Starting " + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        Table ht = TEST_UTIL.createTable(tableName, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getName());
        conf.set("hbase.client.default.rpc.codec", "");
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(tableName);){
            for (int i = 0; i < 10; ++i) {
                Result result;
                Increment inc = new Increment(ROW);
                inc.addColumn(FAMILY, COLUMN, 1L);
                long ttl = i + 3600000;
                inc.setTTL(ttl);
                ht.increment(inc);
                Scan scan = new Scan().withStartRow(ROW);
                ResultScanner scanner = table.getScanner(scan);
                int count = 0;
                while ((result = scanner.next()) != null) {
                    Cell[] cells;
                    for (Cell cell : cells = result.rawCells()) {
                        List tags = PrivateCellUtil.getTags((Cell)cell);
                        Assert.assertEquals((long)1L, (long)tags.size());
                        Tag tag = (Tag)tags.get(0);
                        Assert.assertEquals((long)8L, (long)tag.getType());
                        long ttlTagValue = Bytes.toLong((byte[])tag.getValueArray(), (int)tag.getValueOffset());
                        Assert.assertEquals((long)ttl, (long)ttlTagValue);
                    }
                    ++count;
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
    }
}

