/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestHbck {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHbck.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHbck.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public boolean async;
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestHbck.class.getSimpleName());
    private static ProcedureExecutor<MasterProcedureEnv> procExec;
    private static AsyncConnection ASYNC_CONN;

    @Parameterized.Parameters(name="{index}: async={0}")
    public static List<Object[]> params() {
        return Arrays.asList({false}, {true});
    }

    private Hbck getHbck() throws Exception {
        if (this.async) {
            return (Hbck)ASYNC_CONN.getHbck().get();
        }
        return TEST_UTIL.getHbck();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.createMultiRegionTable(TABLE_NAME, 3, new byte[][]{Bytes.toBytes((String)"family1")});
        procExec = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().load(FailingMergeAfterMetaUpdatedMasterObserver.class, 0x3FFFFFFF, TEST_UTIL.getHBaseCluster().getMaster().getConfiguration());
        TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().load(FailingSplitAfterMetaUpdatedMasterObserver.class, 0x3FFFFFFF, TEST_UTIL.getHBaseCluster().getMaster().getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)ASYNC_CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(3);
    }

    @Test
    public void testBypassProcedure() throws Exception {
        SuspendProcedure proc = new SuspendProcedure();
        long procId = procExec.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        List<Long> pids = Arrays.asList(procId);
        List results = this.getHbck().bypassProcedure(pids, 30000L, false, false);
        Assert.assertTrue((String)"Failed to by pass procedure!", (boolean)((Boolean)results.get(0)));
        TEST_UTIL.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testSetTableStateInMeta() throws Exception {
        Hbck hbck = this.getHbck();
        hbck.setTableStateInMeta(new TableState(TABLE_NAME, TableState.State.DISABLED));
        TableState prevState = hbck.setTableStateInMeta(new TableState(TABLE_NAME, TableState.State.ENABLED));
        Assert.assertTrue((String)("Incorrect previous state! expected=DISABLED, found=" + prevState.getState()), (boolean)prevState.isDisabled());
    }

    @Test
    public void testSetRegionStateInMeta() throws Exception {
        Hbck hbck = this.getHbck();
        Admin admin = TEST_UTIL.getAdmin();
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
        List regions = admin.getRegions(TABLE_NAME);
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        HashMap beforeStates = new HashMap();
        HashMap requestStates = new HashMap();
        regions.forEach(r -> {
            RegionState beforeState = am.getRegionStates().getRegionState(r);
            beforeStates.put(r.getEncodedName(), beforeState.getState());
            LOG.debug("Before test: {} ; {}", r, (Object)beforeState.getState());
            requestStates.put(r.getEncodedName(), RegionState.State.CLOSED);
        });
        Callable<Void> doTest = () -> {
            Map result = hbck.setRegionStateInMeta(requestStates);
            result.forEach((k, v) -> {
                RegionState.State beforeState = (RegionState.State)beforeStates.get(k);
                Assert.assertEquals((String)("response state should match before state; " + k), (Object)beforeState, (Object)v);
            });
            regions.forEach(r -> {
                RegionState afterState = am.getRegionStates().getRegionState(r.getEncodedName());
                RegionState.State expectedState = (RegionState.State)requestStates.get(r.getEncodedName());
                LOG.debug("After test: {}, {}", r, (Object)afterState);
                Assert.assertEquals((String)("state in AM should match requested state ; " + r), (Object)expectedState, (Object)afterState.getState());
            });
            return null;
        };
        ProcedureTestingUtility.restart(procExec, (boolean)true, (boolean)true, null, doTest, null, (boolean)false, (boolean)true);
        hbck.setRegionStateInMeta(beforeStates);
    }

    @Test
    public void testAssigns() throws Exception {
        Hbck hbck = this.getHbck();
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            RegionState rs;
            long pid;
            List regions = admin.getRegions(TABLE_NAME).stream().filter(ri -> ri.getReplicaId() == 0).peek(ri -> {
                RegionState rs = am.getRegionStates().getRegionState(ri.getEncodedName());
                LOG.info("RS: {}", (Object)rs);
            }).collect(Collectors.toList());
            List pids = hbck.unassigns(regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.toList()));
            this.waitOnPids(pids);
            pids = hbck.unassigns(regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.toList()));
            this.waitOnPids(pids);
            Iterator<Object> iterator = pids.iterator();
            while (iterator.hasNext()) {
                pid = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid);
            }
            pids = hbck.unassigns(regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.toList()), true);
            this.waitOnPids(pids);
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                pid = (Long)iterator.next();
                Assert.assertNotEquals((long)-1L, (long)pid);
            }
            hbck.bypassProcedure(pids, 10000L, true, true);
            for (RegionInfo ri2 : regions) {
                rs = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(ri2.getEncodedName());
                LOG.info("RS: {}", (Object)rs.toString());
                Assert.assertTrue((String)rs.toString(), (boolean)rs.isClosed());
            }
            pids = hbck.assigns(regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.toList()));
            this.waitOnPids(pids);
            pids = hbck.assigns(regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.toList()));
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid2 = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid2);
            }
            for (RegionInfo ri3 : regions) {
                rs = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(ri3.getEncodedName());
                LOG.info("RS: {}", (Object)rs.toString());
                Assert.assertTrue((String)rs.toString(), (boolean)rs.isOpened());
            }
            pids = hbck.assigns(Arrays.stream(new String[]{"a", "some rubbish name"}).collect(Collectors.toList()));
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid3 = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid3);
            }
        }
    }

    @Test
    public void testScheduleSCP() throws Exception {
        HRegionServer testRs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        try (Table t = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            TEST_UTIL.loadTable(t, Bytes.toBytes((String)"family1"), true);
        }
        ServerName serverName = testRs.getServerName();
        Hbck hbck = this.getHbck();
        List pids = hbck.scheduleServerCrashProcedures(Arrays.asList(serverName));
        Assert.assertEquals((long)1L, (long)pids.size());
        Assert.assertNotEquals((Object)-1L, pids.get(0));
        LOG.debug("SCP pid is {}", pids.get(0));
        List newPids = hbck.scheduleServerCrashProcedures(Arrays.asList(serverName));
        Assert.assertEquals((long)1L, (long)pids.size());
        Assert.assertEquals((Object)-1L, newPids.get(0));
        this.waitOnPids(pids);
    }

    @Test
    public void testRunHbckChore() throws Exception {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        HbckChore hbckChore = master.getHbckChore();
        Instant endTimestamp = Optional.ofNullable(hbckChore.getLastReport()).map(HbckReport::getCheckingEndTimestamp).orElse(Instant.EPOCH);
        Hbck hbck = this.getHbck();
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(5L), () -> ((Hbck)hbck).runHbckChore());
        HbckReport report = hbckChore.getLastReport();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.getCheckingEndTimestamp().isAfter(endTimestamp));
    }

    private void waitOnPids(List<Long> pids) {
        TEST_UTIL.waitFor(60000L, () -> pids.stream().allMatch(arg_0 -> procExec.isFinished(arg_0)));
    }

    public static class FailingMergeAfterMetaUpdatedMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        public volatile CountDownLatch latch;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.resetLatch();
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void resetLatch() {
            this.latch = new CountDownLatch(1);
        }

        public void postMergeRegionsCommitAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge, RegionInfo mergedRegion) throws IOException {
            this.latch.countDown();
            throw new IOException("this procedure will fail at here forever");
        }
    }

    public static class FailingSplitAfterMetaUpdatedMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        public volatile CountDownLatch latch;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.resetLatch();
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preSplitRegionAfterMETAAction(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            LOG.info("I'm here");
            this.latch.countDown();
            throw new IOException("this procedure will fail at here forever");
        }

        public void resetLatch() {
            this.latch = new CountDownLatch(1);
        }
    }

    public static class SuspendProcedure
    extends ProcedureTestingUtility.NoopProcedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
            throw new ProcedureSuspendedException();
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }
    }
}

