/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestGetScanColumnsWithNewVersionBehavior {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGetScanColumnsWithNewVersionBehavior.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final TableName TABLE = TableName.valueOf((String)"table");
    private static final byte[] CF = new byte[]{99, 102};
    private static final byte[] ROW = new byte[]{114, 111, 119};
    private static final byte[] COLA = new byte[]{97};
    private static final byte[] COLB = new byte[]{98};
    private static final byte[] COLC = new byte[]{99};
    private static final long TS = 42L;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        ColumnFamilyDescriptor cd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setNewVersionBehavior(true).build();
        TEST_UTIL.createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamily(cd).build(), (byte[][])null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException {
        try (Table t = TEST_UTIL.getConnection().getTable(TABLE);){
            Object[] expected = new Cell[]{new KeyValue(ROW, CF, COLA, 42L, COLA), new KeyValue(ROW, CF, COLC, 42L, COLC)};
            Put p = new Put(ROW);
            p.addColumn(CF, COLA, 42L, COLA);
            p.addColumn(CF, COLB, 42L, COLB);
            p.addColumn(CF, COLC, 42L, COLC);
            t.put(p);
            Get get = new Get(ROW);
            get.addColumn(CF, COLA);
            get.addColumn(CF, COLC);
            Result getResult = t.get(get);
            Assert.assertArrayEquals((Object[])expected, (Object[])getResult.rawCells());
            Scan scan = new Scan().withStartRow(ROW);
            scan.addColumn(CF, COLA);
            scan.addColumn(CF, COLC);
            ResultScanner scanner = t.getScanner(scan);
            ArrayList scanResult = new ArrayList();
            Result result = scanner.next();
            while (result != null) {
                scanResult.addAll(result.listCells());
                result = scanner.next();
            }
            Assert.assertArrayEquals((Object[])expected, (Object[])scanResult.toArray(new Cell[scanResult.size()]));
        }
    }
}

