/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestEnableTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEnableTable.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestEnableTable.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDeleteForSureClearsAllTableRowsFromMeta() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILYNAME)).build();
        try {
            TestEnableTable.createTable(TEST_UTIL, tableDescriptor, HBaseTestingUtil.KEYS_FOR_HBA_CREATE_TABLE);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            Assert.fail((String)("Got an exception while creating " + tableName));
        }
        try (Table metaTable = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            Object object;
            try (ResultScanner scanner = metaTable.getScanner(MetaTableAccessor.getScanForTableName((Configuration)TEST_UTIL.getConfiguration(), (TableName)tableName));){
                object = scanner.iterator();
                if (object.hasNext()) {
                    Result result = (Result)object.next();
                    Delete d = new Delete(result.getRow());
                    d.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    LOG.info("Mangled: " + d);
                    metaTable.delete(d);
                }
            }
            admin.disableTable(tableName);
            TEST_UTIL.waitTableDisabled(tableName.getName());
            try {
                TestEnableTable.deleteTable(TEST_UTIL, tableName);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                Assert.fail((String)("Got an exception while deleting " + tableName));
            }
            int rowCount = 0;
            ResultScanner scanner = metaTable.getScanner(MetaTableAccessor.getScanForTableName((Configuration)TEST_UTIL.getConfiguration(), (TableName)tableName));
            object = null;
            try {
                for (Result result : scanner) {
                    LOG.info("Found when none expected: " + result);
                    ++rowCount;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Assert.assertEquals((long)0L, (long)rowCount);
        }
    }

    public static void createTable(HBaseTestingUtil testUtil, TableDescriptor tableDescriptor, byte[][] splitKeys) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class);
        observer.tableCreationLatch = new CountDownLatch(1);
        Admin admin = testUtil.getAdmin();
        if (splitKeys != null) {
            admin.createTable(tableDescriptor, splitKeys);
        } else {
            admin.createTable(tableDescriptor);
        }
        observer.tableCreationLatch.await();
        observer.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(tableDescriptor.getTableName());
    }

    public static void deleteTable(HBaseTestingUtil testUtil, TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class);
        observer.tableDeletionLatch = new CountDownLatch(1);
        Admin admin = testUtil.getAdmin();
        try {
            admin.disableTable(tableName);
        }
        catch (Exception e) {
            LOG.debug("Table: " + tableName + " already disabled, so just deleting it.");
        }
        admin.deleteTable(tableName);
        observer.tableDeletionLatch.await();
        observer.tableDeletionLatch = null;
    }

    public static class MasterSyncObserver
    implements MasterCoprocessor,
    MasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }
}

