/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestClientScannerTimeouts {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientScannerTimeouts.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClientScannerTimeouts.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static AsyncConnection ASYNC_CONN;
    private static Connection CONN;
    private static final byte[] FAMILY;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static final byte[] ROW0;
    private static final byte[] ROW1;
    private static final byte[] ROW2;
    private static final byte[] ROW3;
    private static final int rpcTimeout = 1000;
    private static final int scanTimeout = 3000;
    private static final int metaScanTimeout = 6000;
    private static final int CLIENT_RETRIES_NUMBER = 3;
    private static Table table;
    private static AsyncTable<AdvancedScanResultConsumer> asyncTable;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.msginterval", 30000);
        conf.setInt("hbase.rpc.timeout", 1000);
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithScanTimeout.class.getName()});
        conf.setInt("hbase.client.retries.number", 3);
        conf.setInt("hbase.client.pause", 1000);
        TEST_UTIL.startMiniCluster(1);
        conf.setInt("hbase.client.scanner.timeout.period", 3000);
        conf.setInt("hbase.client.meta.read.rpc.timeout", 6000);
        conf.setInt("hbase.client.meta.scanner.timeout.period", 6000);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
        CONN = ASYNC_CONN.toConnection();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        CONN.close();
        ASYNC_CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setup(boolean isSystemTable) throws IOException {
        RSRpcServicesWithScanTimeout.reset();
        String nameAsString = this.name.getMethodName();
        if (isSystemTable) {
            nameAsString = NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR + ":" + nameAsString;
        }
        TableName tableName = TableName.valueOf((String)nameAsString);
        TEST_UTIL.createTable(tableName, FAMILY);
        table = CONN.getTable(tableName);
        asyncTable = ASYNC_CONN.getTable(tableName);
        this.putToTable(table, ROW0);
        this.putToTable(table, ROW1);
        this.putToTable(table, ROW2);
        this.putToTable(table, ROW3);
        LOG.info("Wrote our four values");
        table.getRegionLocator().getAllRegionLocations();
        RSRpcServicesWithScanTimeout.reset();
    }

    private void expectRow(byte[] expected, Result result) {
        Assert.assertTrue((String)("Expected row: " + Bytes.toString((byte[])expected)), (boolean)Bytes.equals((byte[])expected, (byte[])result.getRow()));
    }

    private void expectNumTries(int expected) {
        Assert.assertEquals((String)("Expected tryNumber=" + expected + ", actual=" + RSRpcServicesWithScanTimeout.tryNumber), (long)expected, (long)RSRpcServicesWithScanTimeout.tryNumber);
        RSRpcServicesWithScanTimeout.tryNumber = 0;
    }

    @Test
    public void testRetryOutOfOrderScannerNextException() throws IOException {
        this.expectRetryOutOfOrderScannerNext(this::getScanner);
    }

    @Test
    public void testRetryOutOfOrderScannerNextExceptionAsync() throws IOException {
        this.expectRetryOutOfOrderScannerNext(this::getAsyncScanner);
    }

    @Test
    public void testNormalScanTimeoutOnNext() throws IOException {
        this.setup(false);
        this.expectTimeoutOnNext(3000, this::getScanner);
    }

    @Test
    public void testNormalScanTimeoutOnNextAsync() throws IOException {
        this.setup(false);
        this.expectTimeoutOnNext(3000, this::getAsyncScanner);
    }

    @Test
    public void testNormalScanTimeoutOnOpenScanner() throws IOException {
        this.setup(false);
        this.expectTimeoutOnOpenScanner(1000, this::getScanner);
    }

    @Test
    public void testNormalScanTimeoutOnOpenScannerAsync() throws IOException {
        this.setup(false);
        this.expectTimeoutOnOpenScanner(1000, this::getAsyncScanner);
    }

    @Test
    public void testMetaScanTimeoutOnNext() throws IOException {
        this.setup(true);
        this.expectTimeoutOnNext(6000, this::getScanner);
    }

    @Test
    public void testMetaScanTimeoutOnNextAsync() throws IOException {
        this.setup(true);
        this.expectTimeoutOnNext(6000, this::getAsyncScanner);
    }

    @Test
    public void testMetaScanTimeoutOnOpenScanner() throws IOException {
        this.setup(true);
        this.expectTimeoutOnOpenScanner(6000, this::getScanner);
    }

    @Test
    public void testMetaScanTimeoutOnOpenScannerAsync() throws IOException {
        this.setup(true);
        this.expectTimeoutOnOpenScanner(6000, this::getAsyncScanner);
    }

    private void expectRetryOutOfOrderScannerNext(Supplier<ResultScanner> scannerSupplier) throws IOException {
        this.setup(false);
        RSRpcServicesWithScanTimeout.seqNoToThrowOn = 1L;
        LOG.info("Opening scanner, expecting no errors from first next() call from openScanner response");
        ResultScanner scanner = scannerSupplier.get();
        Result result = scanner.next();
        this.expectRow(ROW0, result);
        this.expectNumTries(0);
        LOG.info("Making first next() RPC, expecting no errors for seqNo 0");
        result = scanner.next();
        this.expectRow(ROW1, result);
        this.expectNumTries(0);
        LOG.info("Making second next() RPC, expecting OutOfOrderScannerNextException and appropriate retry");
        result = scanner.next();
        this.expectRow(ROW2, result);
        this.expectNumTries(1);
        RSRpcServicesWithScanTimeout.seqNoToThrowOn = -1L;
        LOG.info("Finishing scan, expecting no errors");
        result = scanner.next();
        this.expectRow(ROW3, result);
        scanner.close();
        LOG.info("Testing always throw exception");
        byte[][] expectedResults = new byte[][]{ROW0, ROW1, ROW2, ROW3};
        int i = 0;
        scanner = scannerSupplier.get();
        RSRpcServicesWithScanTimeout.throwAlways = true;
        while (true) {
            LOG.info("Calling scanner.next()");
            result = scanner.next();
            if (result == null) break;
            byte[] expectedResult = expectedResults[i++];
            this.expectRow(expectedResult, result);
        }
        Assert.assertEquals((String)("Expected to exhaust expectedResults array length=" + expectedResults.length + ", actual index=" + i), (long)expectedResults.length, (long)i);
        this.expectNumTries(expectedResults.length - 1);
    }

    private void expectTimeoutOnNext(int timeout, Supplier<ResultScanner> scannerSupplier) throws IOException {
        RSRpcServicesWithScanTimeout.seqNoToSleepOn = 1L;
        RSRpcServicesWithScanTimeout.setSleepForTimeout(timeout);
        LOG.info("Opening scanner, expecting no timeouts from first next() call from openScanner response");
        ResultScanner scanner = scannerSupplier.get();
        Result result = scanner.next();
        this.expectRow(ROW0, result);
        LOG.info("Making first next() RPC, expecting no timeout for seqNo 0");
        result = scanner.next();
        this.expectRow(ROW1, result);
        LOG.info("Making second next() RPC, expecting timeout");
        long start = System.nanoTime();
        try {
            scanner.next();
            Assert.fail((String)"Expected CallTimeoutException");
        }
        catch (RetriesExhaustedException e) {
            Assert.assertTrue((String)"Expected CallTimeoutException", (boolean)(e.getCause() instanceof CallTimeoutException));
        }
        this.expectTimeout(start, timeout);
    }

    private void expectTimeoutOnOpenScanner(int timeout, Supplier<ResultScanner> scannerSupplier) throws IOException {
        RSRpcServicesWithScanTimeout.setSleepForTimeout(timeout);
        RSRpcServicesWithScanTimeout.sleepOnOpen = true;
        LOG.info("Opening scanner, expecting timeout from first next() call from openScanner response");
        long start = System.nanoTime();
        try {
            scannerSupplier.get().next();
            Assert.fail((String)"Expected CallTimeoutException");
        }
        catch (RetriesExhaustedException e) {
            Assert.assertTrue((String)("Expected CallTimeoutException, but was " + e.getCause()), (boolean)(e.getCause() instanceof CallTimeoutException));
        }
        this.expectTimeout(start, timeout);
    }

    private void expectTimeout(long start, int timeout) {
        long duration = System.nanoTime() - start;
        Assert.assertTrue((String)("Expected duration >= " + timeout + ", but was " + duration), (duration >= (long)timeout ? 1 : 0) != 0);
    }

    private ResultScanner getScanner() {
        Scan scan = new Scan();
        scan.setCaching(1);
        try {
            return table.getScanner(scan);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ResultScanner getAsyncScanner() {
        Scan scan = new Scan();
        scan.setCaching(1);
        return asyncTable.getScanner(scan);
    }

    private void putToTable(Table ht, byte[] rowkey) throws IOException {
        Put put = new Put(rowkey);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
    }

    static {
        FAMILY = Bytes.toBytes((String)"testFamily");
        QUALIFIER = Bytes.toBytes((String)"testQualifier");
        VALUE = Bytes.toBytes((String)"testValue");
        ROW0 = Bytes.toBytes((String)"row-0");
        ROW1 = Bytes.toBytes((String)"row-1");
        ROW2 = Bytes.toBytes((String)"row-2");
        ROW3 = Bytes.toBytes((String)"row-3");
    }

    private static class RSRpcServicesWithScanTimeout
    extends RSRpcServices {
        private long tableScannerId;
        private static long seqNoToThrowOn = -1L;
        private static boolean throwAlways = false;
        private static boolean threw;
        private static long seqNoToSleepOn;
        private static boolean sleepOnOpen;
        private static volatile boolean slept;
        private static int tryNumber;
        private static int sleepTime;

        public static void setSleepForTimeout(int timeout) {
            sleepTime = timeout + 500;
        }

        public static void reset() {
            RSRpcServicesWithScanTimeout.setSleepForTimeout(3000);
            seqNoToSleepOn = -1L;
            seqNoToThrowOn = -1L;
            throwAlways = false;
            threw = false;
            sleepOnOpen = false;
            slept = false;
            tryNumber = 0;
        }

        public RSRpcServicesWithScanTimeout(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            if (request.hasScannerId()) {
                ClientProtos.ScanResponse scanResponse = super.scan(controller, request);
                if (this.tableScannerId != request.getScannerId() || request.getCloseScanner()) {
                    return scanResponse;
                }
                if (throwAlways || !threw && request.hasNextCallSeq() && seqNoToThrowOn == request.getNextCallSeq()) {
                    threw = true;
                    LOG.info("THROWING exception, tryNumber={}, tableScannerId={}", (Object)(++tryNumber), (Object)this.tableScannerId);
                    throw new ServiceException((Throwable)new OutOfOrderScannerNextException());
                }
                if (!slept && request.hasNextCallSeq() && seqNoToSleepOn == request.getNextCallSeq()) {
                    try {
                        LOG.info("SLEEPING " + sleepTime);
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    slept = true;
                    ++tryNumber;
                }
                return scanResponse;
            }
            ClientProtos.ScanResponse scanRes = super.scan(controller, request);
            String regionName = Bytes.toString((byte[])request.getRegion().getValue().toByteArray());
            if (!regionName.contains(TableName.META_TABLE_NAME.getNameAsString())) {
                this.tableScannerId = scanRes.getScannerId();
                if (sleepOnOpen) {
                    try {
                        LOG.info("openScanner SLEEPING " + sleepTime);
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return scanRes;
        }

        static {
            seqNoToSleepOn = -1L;
            sleepOnOpen = false;
            tryNumber = 0;
            sleepTime = 1500;
        }
    }

    private static class RegionServerWithScanTimeout
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public RegionServerWithScanTimeout(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new RSRpcServicesWithScanTimeout(this);
        }
    }
}

