/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAlwaysSetScannerId {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAlwaysSetScannerId.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final int COUNT = 10;
    private static RegionInfo HRI;
    private static AsyncConnectionImpl CONN;
    private static ClientProtos.ClientService.Interface STUB;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        try (Table table = UTIL.createTable(TABLE_NAME, CF);){
            for (int i = 0; i < 10; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
            HRI = ((HRegionLocation)table.getRegionLocator().getAllRegionLocations().get(0)).getRegion();
        }
        CONN = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        STUB = CONN.getRegionServerStub(UTIL.getHBaseCluster().getRegionServer(0).getServerName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    private ClientProtos.ScanResponse scan(ClientProtos.ScanRequest req) throws IOException {
        BlockingRpcCallback callback = new BlockingRpcCallback();
        STUB.scan((RpcController)new HBaseRpcControllerImpl(), req, (RpcCallback)callback);
        return (ClientProtos.ScanResponse)callback.get();
    }

    @Test
    public void test() throws ServiceException, IOException {
        Scan scan = new Scan();
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest((byte[])HRI.getRegionName(), (Scan)scan, (int)1, (boolean)false);
        ClientProtos.ScanResponse resp = this.scan(req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        long scannerId = resp.getScannerId();
        int nextCallSeq = 0;
        for (int i = 0; i < 5; ++i) {
            req = RequestConverter.buildScanRequest((long)scannerId, (int)1, (boolean)false, (long)nextCallSeq++, (boolean)false, (boolean)false, (int)-1);
            resp = this.scan(req);
            Assert.assertTrue((boolean)resp.hasScannerId());
            Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
        }
        req = RequestConverter.buildScanRequest((long)scannerId, (int)0, (boolean)false, (long)nextCallSeq++, (boolean)false, (boolean)true, (int)-1);
        resp = this.scan(req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
        req = RequestConverter.buildScanRequest((long)scannerId, (int)0, (boolean)true, (boolean)false);
        resp = this.scan(req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
    }
}

