/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestUpdateConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestUpdateConfiguration.class);
    private static final String SERVER_CONFIG = "hbase-site.xml";
    private static final String OVERRIDE_SERVER_CONFIG = "override-hbase-site.xml";
    private static final String BACKUP_SERVER_CONFIG = "backup-hbase-site.xml";
    private static Path configFileUnderTestDataDir;
    private static Path overrideConfigFileUnderTestDataDir;
    private static Path backupConfigFileUnderTestDataDir;

    protected static void setUpConfigurationFiles(HBaseTestingUtil testUtil) throws Exception {
        String absoluteDataPath = testUtil.getDataTestDir().toString();
        Files.createDirectories(Paths.get(absoluteDataPath, new String[0]), new FileAttribute[0]);
        Path configFile = Paths.get("target", "test-classes", SERVER_CONFIG);
        configFileUnderTestDataDir = Paths.get(absoluteDataPath, SERVER_CONFIG);
        Files.copy(configFile, configFileUnderTestDataDir, new CopyOption[0]);
        Path overrideConfigFile = Paths.get("target", "test-classes", OVERRIDE_SERVER_CONFIG);
        overrideConfigFileUnderTestDataDir = Paths.get(absoluteDataPath, OVERRIDE_SERVER_CONFIG);
        Files.copy(overrideConfigFile, overrideConfigFileUnderTestDataDir, new CopyOption[0]);
        backupConfigFileUnderTestDataDir = Paths.get(absoluteDataPath, BACKUP_SERVER_CONFIG);
        testUtil.getConfiguration().addResource(testUtil.getDataTestDir(SERVER_CONFIG));
    }

    protected static void addResourceToRegionServerConfiguration(HBaseTestingUtil testUtil) {
        for (JVMClusterUtil.RegionServerThread rsThread : testUtil.getMiniHBaseCluster().getRegionServerThreads()) {
            rsThread.getRegionServer().getConfiguration().addResource(testUtil.getDataTestDir(SERVER_CONFIG));
        }
    }

    protected final void replaceHBaseSiteXML() throws IOException {
        LOG.info("Replace hbase config {} with {}", (Object)configFileUnderTestDataDir, (Object)overrideConfigFileUnderTestDataDir);
        Files.copy(configFileUnderTestDataDir, backupConfigFileUnderTestDataDir, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(overrideConfigFileUnderTestDataDir, configFileUnderTestDataDir, StandardCopyOption.REPLACE_EXISTING);
    }

    protected final void restoreHBaseSiteXML() throws IOException {
        LOG.info("Restore hbase config {} with {}", (Object)configFileUnderTestDataDir, (Object)backupConfigFileUnderTestDataDir);
        Files.copy(backupConfigFileUnderTestDataDir, configFileUnderTestDataDir, StandardCopyOption.REPLACE_EXISTING);
    }
}

