/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.RegionReplicationLagEvaluation;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionReplicationLagEvaluation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationLagEvaluation.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.region.replica.replication.enabled", true);
        UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionReplicationLagEvaluation tool = new RegionReplicationLagEvaluation();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)UTIL.getConfiguration(), (Tool)tool, (String[])new String[]{"-r", "1000"}));
        FastLongHistogram histogram = tool.getHistogram();
        Assert.assertEquals((long)1000L, (long)histogram.getCount());
    }
}

