/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FlakeyTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestRegionRebalancing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionRebalancing.class);
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"col");
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionRebalancing.class);
    private final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private RegionLocator regionLocator;
    private TableDescriptor tableDescriptor;
    private String balancerName;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        String[][] balancers = new String[][]{{"org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer"}, {"org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer"}};
        return Arrays.asList(balancers);
    }

    public TestRegionRebalancing(String balancerName) {
        this.balancerName = balancerName;
    }

    @After
    public void after() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        this.UTIL.getConfiguration().set("hbase.master.loadbalancer.class", this.balancerName);
        this.UTIL.startMiniCluster(1);
        this.tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME)).build();
    }

    @Test
    public void testRebalanceOnRegionServerNumberChange() throws IOException, InterruptedException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable(this.tableDescriptor, (byte[][])Arrays.copyOfRange(HBaseTestingUtil.KEYS, 1, HBaseTestingUtil.KEYS.length));
            this.regionLocator = connection.getRegionLocator(this.tableDescriptor.getTableName());
            MetaTableAccessor.fullScanMetaAndPrint((Connection)admin.getConnection());
            Assert.assertEquals((String)"Test table should have right number of regions", (long)HBaseTestingUtil.KEYS.length, (long)this.regionLocator.getStartKeys().length);
            this.assertRegionsAreBalanced();
            LOG.info("Started second server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName());
            this.UTIL.getHBaseCluster().getMaster().balance();
            this.assertRegionsAreBalanced();
            BalanceResponse response = this.UTIL.getHBaseCluster().getMaster().balance();
            Assert.assertTrue((boolean)response.isBalancerRan());
            Assert.assertEquals((long)0L, (long)response.getMovesCalculated());
            Assert.assertEquals((long)0L, (long)response.getMovesExecuted());
            LOG.info("Started third server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName());
            this.waitForAllRegionsAssigned();
            response = this.UTIL.getHBaseCluster().getMaster().balance();
            Assert.assertTrue((boolean)response.isBalancerRan());
            Assert.assertTrue((response.getMovesCalculated() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)response.getMovesCalculated(), (long)response.getMovesExecuted());
            this.assertRegionsAreBalanced();
            LOG.info("Stopped third server=" + this.UTIL.getHBaseCluster().stopRegionServer(2, false));
            this.UTIL.getHBaseCluster().waitOnRegionServer(2);
            this.waitOnCrashProcessing();
            this.UTIL.getHBaseCluster().getMaster().balance();
            this.assertRegionsAreBalanced();
            LOG.info("Readding third server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName());
            LOG.info("Added fourth server=" + this.UTIL.getHBaseCluster().startRegionServer().getRegionServer().getServerName());
            this.waitOnCrashProcessing();
            this.waitForAllRegionsAssigned();
            response = this.UTIL.getHBaseCluster().getMaster().balance();
            Assert.assertTrue((boolean)response.isBalancerRan());
            Assert.assertTrue((response.getMovesCalculated() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)response.getMovesCalculated(), (long)response.getMovesExecuted());
            this.assertRegionsAreBalanced();
            for (int i = 0; i < 6; ++i) {
                LOG.info("Adding " + (i + 5) + "th region server");
                this.UTIL.getHBaseCluster().startRegionServer();
            }
            this.waitForAllRegionsAssigned();
            response = this.UTIL.getHBaseCluster().getMaster().balance();
            Assert.assertTrue((boolean)response.isBalancerRan());
            Assert.assertTrue((response.getMovesCalculated() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)response.getMovesCalculated(), (long)response.getMovesExecuted());
            this.assertRegionsAreBalanced();
            this.regionLocator.close();
        }
    }

    private void waitOnCrashProcessing() throws IOException {
        while (this.UTIL.getHBaseCluster().getMaster().getServerManager().areDeadServersInProgress()) {
            LOG.info("Waiting on processing of crashed server before proceeding...");
            Threads.sleep((long)1000L);
        }
    }

    private void assertRegionsAreBalanced() throws IOException {
        boolean success = false;
        float slop = this.UTIL.getConfiguration().getFloat("hbase.regions.slop", 0.1f);
        if (slop <= 0.0f) {
            slop = 1.0f;
        }
        for (int i = 0; i < 5; ++i) {
            success = true;
            this.waitForAllRegionsAssigned();
            long regionCount = this.UTIL.getMiniHBaseCluster().countServedRegions();
            List<HRegionServer> servers = this.getOnlineRegionServers();
            double avg = (double)regionCount / (double)servers.size();
            int avgLoadPlusSlop = (int)Math.ceil(avg * (double)(1.0f + slop));
            int avgLoadMinusSlop = (int)Math.floor(avg * (double)(1.0f - slop)) - 1;
            if (this.balancerName.contains("StochasticLoadBalancer")) {
                ++avgLoadPlusSlop;
                --avgLoadMinusSlop;
            }
            LOG.debug("There are " + servers.size() + " servers and " + regionCount + " regions. Load Average: " + avg + " low border: " + avgLoadMinusSlop + ", up border: " + avgLoadPlusSlop + "; attempt: " + i);
            for (HRegionServer server : servers) {
                int serverLoad = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices()).size();
                LOG.debug(server.getServerName() + " Avg: " + avg + " actual: " + serverLoad);
                if (avg > 2.0 && serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                for (RegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                    if (!hri.isMetaRegion()) continue;
                    --serverLoad;
                }
                if (serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                LOG.debug(server.getServerName() + " Isn't balanced!!! Avg: " + avg + " actual: " + serverLoad + " slop: " + slop);
                success = false;
                break;
            }
            if (!success) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } else {
                return;
            }
            this.UTIL.getHBaseCluster().getMaster().balance();
        }
        Assert.fail((String)"After 5 attempts, region assignments were not balanced.");
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (JVMClusterUtil.RegionServerThread rst : this.UTIL.getHBaseCluster().getRegionServerThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() throws IOException {
        int totalRegions = HBaseTestingUtil.KEYS.length;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        while (this.UTIL.getMiniHBaseCluster().countServedRegions() < (long)totalRegions) {
            LOG.debug("Waiting for there to be " + totalRegions + " regions, but there are " + this.UTIL.getMiniHBaseCluster().countServedRegions() + " right now.");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        this.UTIL.waitUntilNoRegionsInTransition();
    }
}

