/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHRegionLocation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionLocation.class);

    @Test
    public void testHashAndEqualsCode() {
        ServerName hsa1 = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        HRegionLocation hrl1 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa1);
        HRegionLocation hrl2 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa1);
        Assert.assertEquals((long)hrl1.hashCode(), (long)hrl2.hashCode());
        Assert.assertTrue((boolean)hrl1.equals((Object)hrl2));
        HRegionLocation hrl3 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa1);
        Assert.assertNotSame((Object)hrl1, (Object)hrl3);
        Assert.assertTrue((boolean)hrl1.equals((Object)hrl3));
        ServerName hsa2 = ServerName.valueOf((String)"localhost", (int)12345, (long)-1L);
        HRegionLocation hrl4 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa2);
        Assert.assertFalse((boolean)hrl3.equals((Object)hrl4));
        HRegionLocation hrl5 = new HRegionLocation(hrl4.getRegion(), hrl4.getServerName(), hrl4.getSeqNum() + 1L);
        Assert.assertTrue((boolean)hrl4.equals((Object)hrl5));
    }

    @Test
    public void testToString() {
        ServerName hsa1 = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        HRegionLocation hrl1 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa1);
        System.out.println(hrl1.toString());
    }

    @Test
    public void testCompareTo() {
        ServerName hsa1 = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        HRegionLocation hsl1 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa1);
        ServerName hsa2 = ServerName.valueOf((String)"localhost", (int)1235, (long)-1L);
        HRegionLocation hsl2 = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, hsa2);
        Assert.assertEquals((long)0L, (long)hsl1.compareTo(hsl1));
        Assert.assertEquals((long)0L, (long)hsl2.compareTo(hsl2));
        int compare1 = hsl1.compareTo(hsl2);
        int compare2 = hsl2.compareTo(hsl1);
        Assert.assertTrue((boolean)(compare1 > 0 ? compare2 < 0 : compare2 > 0));
    }
}

