/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.DelegatingHBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestCustomPriorityRpcControllerFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCustomPriorityRpcControllerFactory.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final AtomicReference<State> STATE = new AtomicReference<State>(State.SETUP);
    private static final AtomicInteger EXPECTED_PRIORITY = new AtomicInteger();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"Timeout");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
    private static final byte[] VALUE = Bytes.toBytes((long)1L);
    private static final int MIN_CUSTOM_PRIORITY = 201;
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUpClass() throws Exception {
        UTIL.startMiniCluster(StartTestingClusterOption.builder().rsClass(PriorityRegionServer.class).build());
        TableDescriptor descriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        UTIL.getAdmin().createTable(descriptor);
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setClass("hbase.rpc.controllerfactory.class", PriorityRpcControllerFactory.class, RpcControllerFactory.class);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
    }

    @Test
    public void tetGetPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                TABLE.get(new Get(ROW));
            }
        });
    }

    @Test
    public void testDeletePriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                TABLE.delete(new Delete(ROW));
            }
        });
    }

    @Test
    public void testIncrementPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                TABLE.increment(new Increment(ROW).addColumn(FAMILY, QUALIFIER, 1L));
            }
        });
    }

    @Test
    public void testAppendPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                TABLE.append(new Append(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
            }
        });
    }

    @Test
    public void testPutPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                TABLE.put(put);
            }
        });
    }

    @Test
    public void testExistsPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                TABLE.exists(new Get(ROW));
            }
        });
    }

    @Test
    public void testMutatePriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                RowMutations mutation = new RowMutations(ROW);
                mutation.add((Mutation)new Delete(ROW));
                mutation.add((Mutation)new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
                TABLE.mutateRow(mutation);
            }
        });
    }

    @Test
    public void testCheckAndMutatePriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                RowMutations mutation = new RowMutations(ROW);
                mutation.add((Mutation)new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
                TABLE.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROW).ifNotExists(FAMILY, QUALIFIER).build(mutation));
            }
        });
    }

    @Test
    public void testMultiGetsPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws Exception {
                Get get1 = new Get(ROW);
                get1.addColumn(FAMILY, QUALIFIER);
                Get get2 = new Get(ROW);
                get2.addColumn(FAMILY, QUALIFIER);
                ArrayList<Get> gets = new ArrayList<Get>();
                gets.add(get1);
                gets.add(get2);
                TABLE.batch(gets, new Object[2]);
            }
        });
    }

    @Test
    public void testMultiPutsPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws Exception {
                Put put1 = new Put(ROW);
                put1.addColumn(FAMILY, QUALIFIER, VALUE);
                Put put2 = new Put(ROW);
                put2.addColumn(FAMILY, QUALIFIER, VALUE);
                ArrayList<Put> puts = new ArrayList<Put>();
                puts.add(put1);
                puts.add(put2);
                TABLE.batch(puts, new Object[2]);
            }
        });
    }

    @Test
    public void testScanPriority() throws Exception {
        this.testForCall(new ThrowingCallable(){

            @Override
            public void call() throws IOException {
                ResultScanner scanner = TABLE.getScanner(new Scan());
                scanner.next();
            }
        });
    }

    private void testForCall(ThrowingCallable callable) throws Exception {
        STATE.set(State.WAITING);
        EXPECTED_PRIORITY.set(new Random().nextInt(201) + 201);
        callable.call();
        Assert.assertEquals((String)"Expected state to change to SUCCESS. Check for assertion error in logs", (Object)((Object)STATE.get()), (Object)((Object)State.SUCCESS));
    }

    public static class PriorityRpcServices
    extends RSRpcServices {
        PriorityRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        private void checkPriorityIfWaiting() {
            if (STATE.get() == State.WAITING) {
                int priority = ((RpcCall)RpcServer.getCurrentCall().get()).getPriority();
                if (priority < 201) {
                    return;
                }
                Assert.assertEquals((long)EXPECTED_PRIORITY.get(), (long)priority);
                STATE.set(State.SUCCESS);
            }
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.checkPriorityIfWaiting();
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
            this.checkPriorityIfWaiting();
            return super.mutate(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.checkPriorityIfWaiting();
            return super.scan(controller, request);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            this.checkPriorityIfWaiting();
            return super.multi(rpcc, request);
        }
    }

    private static class PriorityController
    extends DelegatingHBaseRpcController {
        private final int priority;

        public PriorityController(int priority, HBaseRpcController controller) {
            super(controller);
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static class PriorityRpcControllerFactory
    extends RpcControllerFactory {
        public PriorityRpcControllerFactory(Configuration conf) {
            super(conf);
        }

        public HBaseRpcController newController() {
            return new PriorityController(EXPECTED_PRIORITY.get(), super.newController());
        }

        public HBaseRpcController newController(CellScanner cellScanner) {
            return new PriorityController(EXPECTED_PRIORITY.get(), super.newController(cellScanner));
        }

        public HBaseRpcController newController(List<CellScannable> cellIterables) {
            return new PriorityController(EXPECTED_PRIORITY.get(), super.newController(cellIterables));
        }
    }

    public static class PriorityRegionServer
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public PriorityRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new PriorityRpcServices(this);
        }
    }

    private static interface ThrowingCallable {
        public void call() throws Exception;
    }

    private static enum State {
        SETUP,
        WAITING,
        SUCCESS;

    }
}

