/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.net.BindException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestClusterPortAssignment {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterPortAssignment.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestClusterPortAssignment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testClusterPortAssignment() throws Exception {
        boolean retry = false;
        do {
            int masterPort = HBaseTestingUtil.randomFreePort();
            int masterInfoPort = HBaseTestingUtil.randomFreePort();
            int rsPort = HBaseTestingUtil.randomFreePort();
            int rsInfoPort = HBaseTestingUtil.randomFreePort();
            TEST_UTIL.getConfiguration().setBoolean("hbase.localcluster.assign.random.ports", false);
            TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", false);
            TEST_UTIL.getConfiguration().setBoolean("fs.hdfs.impl.disable.cache", true);
            TEST_UTIL.getConfiguration().setInt("hbase.master.port", masterPort);
            TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", masterInfoPort);
            TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", rsPort);
            TEST_UTIL.getConfiguration().setInt("hbase.regionserver.info.port", rsInfoPort);
            LOG.info("Ports: {}, {}, {}, {}", new Object[]{masterPort, masterInfoPort, rsPort, rsInfoPort});
            try {
                SingleProcessHBaseCluster cluster = TEST_UTIL.startMiniCluster();
                Assert.assertTrue((String)"Cluster failed to come up", (boolean)cluster.waitForActiveAndReadyMaster(30000L));
                retry = false;
                Assert.assertEquals((String)"Master RPC port is incorrect", (long)masterPort, (long)cluster.getMaster().getRpcServer().getListenerAddress().getPort());
                Assert.assertEquals((String)"Master info port is incorrect", (long)masterInfoPort, (long)cluster.getMaster().getInfoServer().getPort());
                Assert.assertEquals((String)"RS RPC port is incorrect", (long)rsPort, (long)cluster.getRegionServer(0).getRpcServer().getListenerAddress().getPort());
                Assert.assertEquals((String)"RS info port is incorrect", (long)rsInfoPort, (long)cluster.getRegionServer(0).getInfoServer().getPort());
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof BindException) {
                    LOG.info("Failed bind, need to retry", (Throwable)e);
                    retry = true;
                    continue;
                }
                LOG.error("Failed to start mini cluster", (Throwable)e);
                retry = false;
                Assert.fail((String)"Failed to start mini cluster with assigned ports.");
            }
            finally {
                TEST_UTIL.shutdownMiniCluster();
            }
        } while (retry);
    }
}

