/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jakartawrappers.ServletWrapper;

public final class WebSocketHandler {
    private static final String JETTY_WEB_SOCKET_SERVLET_CLASS = "JettyWebSocketServlet";
    private final AtomicBoolean lazyFirstInitCall = new AtomicBoolean(true);
    private final CountDownLatch initBarrier = new CountDownLatch(1);
    private final ServletHandler servletHandler;

    public WebSocketHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public void lazyInit() {
        if (this.lazyFirstInitCall.compareAndSet(true, false)) {
            try {
                this.servletHandler.init();
            }
            catch (Exception e) {
                SystemLogger.LOGGER.error(SystemLogger.formatMessage(this.servletHandler.getServletInfo().getServiceReference(), "Error calling init() lazy on servlet ".concat(this.servletHandler.getServletInfo().getClassName(this.servletHandler.getServlet()))), (Throwable)e);
            }
            finally {
                this.initBarrier.countDown();
            }
        } else {
            try {
                this.initBarrier.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean shouldInit() {
        return !this.lazyFirstInitCall.get() && this.initBarrier.getCount() > 0L;
    }

    public boolean shouldDestroy() {
        if (!this.lazyFirstInitCall.get()) {
            try {
                this.initBarrier.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    public static boolean isJettyWebSocketServlet(Object servlet) {
        Class<?> superClass = servlet.getClass().getSuperclass();
        SystemLogger.LOGGER.debug("Checking if the servlet is a JettyWebSocketServlet: '" + superClass.getSimpleName() + "'");
        boolean isJettyWebSocketServlet = superClass.getSimpleName().endsWith(JETTY_WEB_SOCKET_SERVLET_CLASS);
        if (!isJettyWebSocketServlet) {
            if (servlet instanceof ServletWrapper) {
                Servlet wrappedServlet = ((ServletWrapper)servlet).getServlet();
                return WebSocketHandler.isJettyWebSocketServlet(wrappedServlet);
            }
            if (servlet instanceof org.apache.felix.http.javaxwrappers.ServletWrapper) {
                jakarta.servlet.Servlet wrappedServlet = ((org.apache.felix.http.javaxwrappers.ServletWrapper)servlet).getServlet();
                return WebSocketHandler.isJettyWebSocketServlet(wrappedServlet);
            }
        }
        return isJettyWebSocketServlet;
    }
}

