/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractInfo<T>
implements Comparable<AbstractInfo<T>> {
    private final int ranking;
    private final long serviceId;
    private final ServiceReference<T> serviceReference;
    private final String target;

    public AbstractInfo(ServiceReference<T> ref) {
        this.serviceId = (Long)ref.getProperty("service.id");
        Object rankingObj = ref.getProperty("service.ranking");
        this.ranking = rankingObj instanceof Integer ? (Integer)rankingObj : 0;
        this.serviceReference = ref;
        this.target = this.getStringProperty(ref, "osgi.http.whiteboard.target");
    }

    public AbstractInfo(int ranking, long serviceId) {
        this.ranking = ranking;
        this.serviceId = serviceId;
        this.serviceReference = null;
        this.target = null;
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public int compareTo(AbstractInfo<T> other) {
        if (this.ranking == other.ranking) {
            if (this.serviceId == other.serviceId) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int reverseOrder = this.serviceId >= 0L && other.serviceId >= 0L ? 1 : -1;
            return reverseOrder * Long.valueOf(this.serviceId).compareTo(other.serviceId);
        }
        int result = Integer.valueOf(other.ranking).compareTo(this.ranking);
        return result;
    }

    public boolean isSame(AbstractInfo<T> other) {
        if (this.serviceId != other.serviceId) {
            return false;
        }
        if (this.ranking != other.ranking) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }

    protected boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    protected boolean isEmpty(String[] value) {
        return value == null || value.length == 0;
    }

    protected String getStringProperty(ServiceReference<T> ref, String key) {
        Object value = ref.getProperty(key);
        return value instanceof String ? ((String)value).trim() : null;
    }

    protected String[] getStringArrayProperty(ServiceReference<T> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return new String[]{((String)value).trim()};
        }
        if (value instanceof String[]) {
            String[] arr = (String[])value;
            String[] values = new String[arr.length];
            int j = 0;
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                values[j++] = arr[i].trim();
            }
            return values;
        }
        if (value instanceof Collection) {
            Collection collectionValues = (Collection)value;
            String[] values = new String[collectionValues.size()];
            int i = 0;
            for (Object current : collectionValues) {
                values[i++] = current != null ? String.valueOf(current).trim() : null;
            }
            return values;
        }
        return null;
    }

    protected boolean getBooleanProperty(ServiceReference<T> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected Map<String, String> getInitParams(ServiceReference<T> ref, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : ref.getPropertyKeys()) {
            if (!key.startsWith(prefix)) continue;
            String paramKey = key.substring(prefix.length());
            String paramValue = this.getStringProperty(ref, key);
            if (paramValue == null) continue;
            result.put(paramKey, paramValue);
        }
        return Collections.unmodifiableMap(result);
    }

    public int getRanking() {
        return this.ranking;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public String getTarget() {
        return this.target;
    }

    public ServiceReference<T> getServiceReference() {
        return this.serviceReference;
    }

    public int hashCode() {
        return 31 + (int)(this.serviceId ^ this.serviceId >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInfo other = (AbstractInfo)obj;
        return this.serviceId == other.serviceId;
    }

    public T getService(BundleContext bundleContext) {
        return ServiceUtils.safeGetServiceObjects(bundleContext, this.getServiceReference());
    }

    public void ungetService(BundleContext bundleContext, T service) {
        ServiceUtils.safeUngetServiceObjects(bundleContext, this.getServiceReference(), service);
    }

    @NotNull
    public abstract String getType();
}

