/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.dispatch.IncludeResponseWrapper;
import org.apache.felix.http.base.internal.dispatch.InvocationChain;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.registry.ServletResolution;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.jetbrains.annotations.NotNull;

public final class RequestDispatcherImpl
implements RequestDispatcher {
    private final RequestInfo requestInfo;
    private final ServletResolution resolution;

    public RequestDispatcherImpl(@NotNull ServletResolution resolution, @NotNull RequestInfo requestInfo) {
        this.resolution = resolution;
        this.requestInfo = requestInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new ServletException("Response has been committed");
        }
        response.resetBuffer();
        try {
            ServletRequestWrapper req = new ServletRequestWrapper((HttpServletRequest)request, this.resolution.handler.getContext(), this.requestInfo, DispatcherType.FORWARD, this.resolution.handler.getServletInfo().isAsyncSupported(), this.resolution.handler.getMultipartConfig(), this.resolution.handler.getMultipartSecurityContext());
            String requestURI = UriUtils.concat(this.requestInfo.servletPath, this.requestInfo.pathInfo);
            FilterHandler[] filterHandlers = this.resolution.handlerRegistry.getFilterHandlers(this.resolution.handler, DispatcherType.FORWARD, requestURI);
            InvocationChain filterChain = new InvocationChain(this.resolution.handler, filterHandlers);
            filterChain.doFilter((ServletRequest)req, response);
        }
        finally {
            if (!request.isAsyncStarted()) {
                response.flushBuffer();
                try {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException ise) {
                        response.getOutputStream().close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestWrapper req = new ServletRequestWrapper((HttpServletRequest)request, this.resolution.handler.getContext(), this.requestInfo, DispatcherType.INCLUDE, this.resolution.handler.getServletInfo().isAsyncSupported(), this.resolution.handler.getMultipartConfig(), this.resolution.handler.getMultipartSecurityContext());
        String requestURI = UriUtils.concat(this.requestInfo.servletPath, this.requestInfo.pathInfo);
        FilterHandler[] filterHandlers = this.resolution.handlerRegistry.getFilterHandlers(this.resolution.handler, DispatcherType.INCLUDE, requestURI);
        InvocationChain filterChain = new InvocationChain(this.resolution.handler, filterHandlers);
        filterChain.doFilter((ServletRequest)req, (ServletResponse)new IncludeResponseWrapper((HttpServletResponse)response));
    }
}

