/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

@Typed
public abstract class ContextUtils {
    private ContextUtils() {
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass) {
        return ContextUtils.isContextActive(scopeAnnotationClass, BeanManagerProvider.getInstance().getBeanManager());
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass, BeanManager beanManager) {
        try {
            if (beanManager.getContext(scopeAnnotationClass) == null || !beanManager.getContext(scopeAnnotationClass).isActive()) {
                return false;
            }
        }
        catch (ContextNotActiveException e) {
            return false;
        }
        return true;
    }
}

