/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.scope.conversation;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.core.api.scope.ConversationSubGroup;
import org.apache.deltaspike.core.api.scope.GroupedConversationScoped;
import org.apache.deltaspike.core.impl.scope.conversation.ConversationBeanHolder;
import org.apache.deltaspike.core.impl.scope.conversation.ConversationKey;
import org.apache.deltaspike.core.impl.scope.window.WindowContextImpl;
import org.apache.deltaspike.core.impl.util.ConversationUtils;
import org.apache.deltaspike.core.spi.scope.conversation.GroupedConversationManager;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualInstanceInfo;
import org.apache.deltaspike.core.util.context.ContextualStorage;

@Typed
public class GroupedConversationContext
extends AbstractContext
implements GroupedConversationManager {
    private static final long serialVersionUID = -5463564406828391468L;
    private final BeanManager beanManager;
    private final WindowContextImpl windowContext;
    private ConversationBeanHolder conversationBeanHolder;

    public GroupedConversationContext(BeanManager beanManager, WindowContextImpl windowContext) {
        super(beanManager);
        this.beanManager = beanManager;
        this.windowContext = windowContext;
    }

    public void init(ConversationBeanHolder conversationBeanHolder) {
        this.conversationBeanHolder = conversationBeanHolder;
    }

    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        ConversationKey conversationKey = ConversationUtils.convertToConversationKey(contextual, this.beanManager);
        return this.conversationBeanHolder.getContextualStorage(this.beanManager, conversationKey, createIfNotExist);
    }

    protected List<ContextualStorage> getActiveContextualStorages() {
        ArrayList<ContextualStorage> result = new ArrayList<ContextualStorage>();
        result.addAll(this.conversationBeanHolder.getStorageMap().values());
        return result;
    }

    public Class<? extends Annotation> getScope() {
        return GroupedConversationScoped.class;
    }

    public boolean isActive() {
        return this.windowContext.isActive();
    }

    public ContextualStorage closeConversation(Class<?> conversationGroup, Annotation ... qualifiers) {
        ConversationKey conversationKey = new ConversationKey(conversationGroup, qualifiers);
        ContextualStorage contextualStorage = this.conversationBeanHolder.getStorageMap().remove(conversationKey);
        if (contextualStorage != null) {
            AbstractContext.destroyAllActive((ContextualStorage)contextualStorage);
        }
        return contextualStorage;
    }

    public Set<ContextualStorage> closeConversationGroup(Class<?> conversationGroup) {
        HashSet<ContextualStorage> result = new HashSet<ContextualStorage>();
        ConversationSubGroup conversationSubGroup = conversationGroup.getAnnotation(ConversationSubGroup.class);
        HashSet subGroups = null;
        if (conversationSubGroup != null) {
            conversationGroup = ConversationUtils.getDeclaredConversationGroup(conversationGroup);
            subGroups = new HashSet(conversationSubGroup.subGroup().length);
            Collections.addAll(subGroups, conversationSubGroup.subGroup());
        }
        Map storageMap = this.conversationBeanHolder.getStorageMap();
        for (Map.Entry<ConversationKey, ContextualStorage> entry : storageMap.entrySet()) {
            if (!((ConversationKey)entry.getKey()).getConversationGroup().equals(conversationGroup)) continue;
            if (subGroups == null) {
                AbstractContext.destroyAllActive((ContextualStorage)entry.getValue());
                result.add(entry.getValue());
                storageMap.remove(entry.getKey());
                continue;
            }
            this.tryToDestroySubGroup(subGroups, entry);
            if (!entry.getValue().getStorage().isEmpty()) continue;
            storageMap.remove(entry.getKey());
        }
        return result;
    }

    private void tryToDestroySubGroup(Set<Class<?>> subGroups, Map.Entry<ConversationKey, ContextualStorage> entry) {
        ContextualStorage storage = entry.getValue();
        block0: for (Map.Entry storageEntry : storage.getStorage().entrySet()) {
            for (Class<?> subGroup : subGroups) {
                Class<?> classOfEntry;
                if (!subGroup.equals(classOfEntry = ((ContextualInstanceInfo)storageEntry.getValue()).getContextualInstance().getClass()) && (!subGroup.isInterface() || !subGroup.isAssignableFrom(classOfEntry))) continue;
                Contextual bean = storage.getBean(storageEntry.getKey());
                AbstractContext.destroyBean((Contextual)bean, (ContextualInstanceInfo)((ContextualInstanceInfo)storageEntry.getValue()));
                storage.getStorage().remove(storageEntry.getKey());
                continue block0;
            }
        }
    }

    public void closeConversations() {
        this.conversationBeanHolder.destroyBeans();
    }
}

