/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.util;

import jakarta.enterprise.inject.Typed;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.deltaspike.core.api.config.view.DefaultErrorView;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.config.view.navigation.ViewNavigationHandler;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.security.api.authorization.AccessDecisionState;
import org.apache.deltaspike.security.api.authorization.AccessDecisionVoterContext;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.ErrorViewAwareAccessDeniedException;
import org.apache.deltaspike.security.api.authorization.Secured;
import org.apache.deltaspike.security.api.authorization.SecurityViolation;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;
import org.apache.deltaspike.security.spi.authorization.SecurityViolationHandler;

@Typed
public abstract class SecurityUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeVoters(EditableAccessDecisionVoterContext accessDecisionVoterContext, ConfigDescriptor<?> viewConfigDescriptor) {
        if (viewConfigDescriptor == null) {
            return;
        }
        List securedMetaData = viewConfigDescriptor.getMetaData(Secured.class);
        if (securedMetaData.isEmpty()) {
            return;
        }
        accessDecisionVoterContext.addMetaData(ViewConfig.class.getName(), (Object)viewConfigDescriptor.getConfigClass());
        for (Annotation viewMetaData : viewConfigDescriptor.getMetaData()) {
            if (viewMetaData.annotationType().equals(Secured.class)) continue;
            accessDecisionVoterContext.addMetaData(viewMetaData.annotationType().getName(), (Object)viewMetaData);
        }
        Secured.Descriptor securedDescriptor = (Secured.Descriptor)viewConfigDescriptor.getExecutableCallbackDescriptor(Secured.class, Secured.Descriptor.class);
        AccessDecisionState voterState = AccessDecisionState.VOTE_IN_PROGRESS;
        try {
            accessDecisionVoterContext.setState(voterState);
            List violations = securedDescriptor.execute((AccessDecisionVoterContext)accessDecisionVoterContext);
            Set<SecurityViolation> allViolations = SecurityUtils.createViolationResult(violations);
            if (!allViolations.isEmpty()) {
                voterState = AccessDecisionState.VIOLATION_FOUND;
                for (SecurityViolation violation : allViolations) {
                    accessDecisionVoterContext.addViolation(violation);
                }
                Class errorView = ((Secured)securedMetaData.iterator().next()).errorView();
                throw new ErrorViewAwareAccessDeniedException(allViolations, errorView);
            }
        }
        finally {
            if (AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)voterState)) {
                voterState = AccessDecisionState.NO_VIOLATION_FOUND;
            }
            accessDecisionVoterContext.setState(voterState);
        }
    }

    private static Set<SecurityViolation> createViolationResult(List<Set<SecurityViolation>> violations) {
        if (violations == null || violations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<SecurityViolation> result = new HashSet<SecurityViolation>();
        for (Set<SecurityViolation> securityViolationSet : violations) {
            result.addAll(securityViolationSet);
        }
        return result;
    }

    public static void handleSecurityViolationWithoutNavigation(RuntimeException exception) {
        SecurityUtils.tryToHandleSecurityViolation(exception, false);
    }

    public static void tryToHandleSecurityViolation(RuntimeException exception) {
        SecurityUtils.tryToHandleSecurityViolation(exception, true);
    }

    private static void tryToHandleSecurityViolation(RuntimeException runtimeException, boolean allowNavigation) {
        ViewConfigResolver viewConfigResolver;
        ViewConfigDescriptor errorPageDescriptor;
        ErrorViewAwareAccessDeniedException exception = SecurityUtils.extractException(runtimeException);
        if (exception == null) {
            throw runtimeException;
        }
        Class errorView = null;
        Class inlineErrorView = exception.getErrorView();
        if (inlineErrorView != null && !DefaultErrorView.class.getName().equals(inlineErrorView.getName())) {
            errorView = inlineErrorView;
        }
        if (errorView == null && (errorPageDescriptor = (viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0])).getDefaultErrorViewConfigDescriptor()) != null) {
            errorView = errorPageDescriptor.getConfigClass();
        }
        if (errorView == null && allowNavigation) {
            throw exception;
        }
        SecurityUtils.processApplicationSecurityException((AccessDeniedException)exception, errorView, allowNavigation);
    }

    private static ErrorViewAwareAccessDeniedException extractException(Throwable exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof ErrorViewAwareAccessDeniedException) {
            return (ErrorViewAwareAccessDeniedException)exception;
        }
        return SecurityUtils.extractException(exception.getCause());
    }

    private static void processApplicationSecurityException(AccessDeniedException exception, Class<? extends ViewConfig> errorView, boolean allowNavigation) {
        SecurityViolationHandler securityViolationHandler = (SecurityViolationHandler)BeanProvider.getContextualReference(SecurityViolationHandler.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (securityViolationHandler != null) {
            securityViolationHandler.processSecurityViolations(exception.getViolations());
        } else {
            SecurityUtils.addViolationsAsMessage(exception.getViolations());
        }
        if (allowNavigation) {
            ((ViewNavigationHandler)BeanProvider.getContextualReference(ViewNavigationHandler.class, (Annotation[])new Annotation[0])).navigateTo(errorView);
        }
    }

    private static void addViolationsAsMessage(Set<SecurityViolation> violations) {
        for (SecurityViolation violation : violations) {
            String message = violation.getReason();
            if (SecurityUtils.isMessageAddedAlready(message)) continue;
            FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message);
            FacesContext.getCurrentInstance().addMessage(null, facesMessage);
        }
    }

    private static boolean isMessageAddedAlready(String message) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null || message == null) {
            return false;
        }
        List existingMessages = facesContext.getMessageList();
        if (existingMessages == null) {
            return false;
        }
        for (FacesMessage facesMessage : existingMessages) {
            if (!message.equals(facesMessage.getSummary())) continue;
            return true;
        }
        return false;
    }
}

