/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.run.run;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.TestConfiguration;

public class derbyrunjartest
extends BaseTestCase {
    public derbyrunjartest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<derbyrunjartest> cl = derbyrunjartest.class;
        BaseTestSuite suite = new BaseTestSuite(cl);
        if (Derby.hasServer()) {
            suite.addTest((Test)new derbyrunjartest("xtestServer"));
        }
        return suite;
    }

    private void runtool(String[] toolArgs, String[] output, int exitCode) throws Exception {
        String runClassName = run.class.getName();
        URL result = TestConfiguration.getURL(runClassName);
        String derbyrunloc = null;
        if (result.toString().endsWith(".jar")) {
            derbyrunloc = result.toString().substring(5);
            if (System.getProperty("os.name").startsWith("Windows")) {
                derbyrunloc = derbyrunloc.substring(1);
            }
        }
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (derbyrunloc == null) {
            cmdArgs.add(runClassName);
        } else {
            cmdArgs.add("-jar");
            cmdArgs.add(derbyrunloc);
        }
        cmdArgs.addAll(Arrays.asList(toolArgs));
        String[] cmd = cmdArgs.toArray(new String[cmdArgs.size()]);
        derbyrunjartest.assertExecJavaCmdAsExpected(output, cmd, exitCode);
    }

    public void testIJ() throws Exception {
        String[] cmd = new String[]{"ij", "--help"};
        String[] output = new String[]{"Usage: java org.apache.derby.tools.ij [-p propertyfile] [inputfile]"};
        this.runtool(cmd, output, 0);
    }

    public void testSysinfo() throws Exception {
        String[] cmd = new String[]{"sysinfo", "-cp", "help"};
        String[] output = new String[]{"Usage: java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [ anyClass.class ] ]"};
        this.runtool(cmd, output, 0);
    }

    public void testDblook() throws Exception {
        String[] cmd = new String[]{"dblook"};
        String[] output = new String[]{" Usage:", " java org.apache.derby.tools.dblook -d <source database url> [options]", " \twhere the source URL is the full URL, including the connection protocol", " \tand any connection attributes that might apply.  For example, use", " \toptions include:", " \t-z <schema name> to specify a schema to which the DDL generation", " \t should be limited.  Only database objects with that schema will have", " \t their DDL generated.", " \t-t <table one> <table two> ... to specify a list of tables for which", " \t the DDL will be generated; any tables not in the list will be ignored.", " \t-td <value> to specify what should be appended to the end", " \t of each DDL statement.", "\t\tThis defaults to ';'.", " \t-noview to prevent the generation of DDL for views.", " \t-append to keep from overwriting the output files.", " \t-verbose to have error messages printed to the console (in addition", " \t to the log file).  If not specified, errors will only be printed to the", " \t log file.", " \t-o <filename> to specify the file name to which the generated DDL", " \t will be written.", " \t\tIf not specified, default is the console."};
        this.runtool(cmd, output, 0);
    }

    public void xtestServer() throws Exception {
        String[] cmd = new String[]{"server"};
        String[] output = new String[]{"Usage: NetworkServerControl <commands> ", "Commands:", "start [-h <host>] [-p <port number>] [-noSecurityManager] [-ssl <ssl mode>]", "shutdown [-h <host>][-p <port number>] [-ssl <ssl mode>] [-user <username>] [-password <password>]", "ping [-h <host>][-p <port number>] [-ssl <ssl mode>]", "sysinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "runtimeinfo [-h <host>][-p <port number>] [-ssl <ssl mode>]", "logconnections { on|off } [-h <host>][-p <port number>] [-ssl <ssl mode>]", "maxthreads <max>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "timeslice <milliseconds>[-h <host>][-p <port number>] [-ssl <ssl mode>]", "trace { on|off } [-s <session id>][-h <host>][-p <port number>] [-ssl <ssl mode>]", "tracedirectory <trace directory>[-h <host>][-p <port number>] [-ssl <ssl mode>]"};
        this.runtool(cmd, output, 1);
    }
}

