/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derbyTesting.functionTests.tests.lang.EnumeratorTableFunction;

public class ZipFileTableFunction
extends EnumeratorTableFunction {
    private static final String[] COLUMN_NAMES = new String[]{"name", "directory", "comment", "compressed_size", "crc", "size", "modification_time"};

    public static ResultSet zipFile(String fileName) throws SQLException {
        return new ZipFileTableFunction(fileName);
    }

    public ZipFileTableFunction(String zipFileName) throws SQLException {
        super(COLUMN_NAMES);
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            this.setEnumeration(zipFile.entries());
        }
        catch (IOException ioe) {
            throw this.wrap(ioe);
        }
    }

    @Override
    public String[] makeRow(Object obj) throws SQLException {
        String directoryName;
        String name;
        int idx = 0;
        ZipEntry zipEntry = (ZipEntry)obj;
        String rawName = zipEntry.getName();
        int stubIdx = rawName.lastIndexOf(47);
        if (stubIdx < 0) {
            name = rawName;
            directoryName = "";
        } else {
            name = rawName.substring(stubIdx + 1, rawName.length());
            directoryName = rawName.substring(0, stubIdx);
        }
        String[] row = new String[this.getColumnCount()];
        row[idx++] = name;
        row[idx++] = directoryName;
        row[idx++] = zipEntry.getComment();
        row[idx++] = Long.toString(zipEntry.getCompressedSize());
        row[idx++] = Long.toString(zipEntry.getCrc());
        row[idx++] = Long.toString(zipEntry.getSize());
        row[idx++] = Long.toString(zipEntry.getTime());
        return row;
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }
}

