/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby6725GetDatabaseName
extends BaseJDBCTestCase {
    public Derby6725GetDatabaseName(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.defaultSuite(Derby6725GetDatabaseName.class);
        test = TestConfiguration.additionalDatabaseDecorator(test, "FIRSTDB1");
        test = TestConfiguration.additionalDatabaseDecorator(test, "SECONDDB2");
        return test;
    }

    public void testDatabaseName() throws SQLException {
        this.checkDbName(this.getConnection(), "wombat");
        this.checkDbName(this.openConnection("FIRSTDB1"), "singleUse/oneuse0");
        this.checkDbName(this.openConnection("SECONDDB2"), "singleUse/oneuse1");
    }

    private void checkDbName(Connection conn, String expectedDbName) throws SQLException {
        File systemDir = new File("system");
        File dbDir = new File(systemDir, expectedDbName);
        String databasePath = PrivilegedFileOpsForTests.getAbsolutePath(dbDir);
        PreparedStatement ps = conn.prepareStatement("values syscs_util.SYSCS_GET_DATABASE_NAME()");
        ResultSet rs = ps.executeQuery();
        rs.next();
        Derby6725GetDatabaseName.assertEquals((String)databasePath, (String)rs.getString(1));
        rs.close();
        ps.close();
    }
}

