/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XAJNDITest
extends BaseJDBCTestCase {
    private static String ldapServer;
    private static String ldapPort;
    private static String dnString;
    private InitialDirContext ic = this.getInitialDirContext();

    public XAJNDITest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            ldapServer = XAJNDITest.getSystemProperty("derbyTesting.ldapServer");
            if (ldapServer == null || ldapServer.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.ldapServer set, eg: -DderbyTesting.ldapServer=myldapserver.myorg.org");
            }
            ldapPort = XAJNDITest.getSystemProperty("derbyTesting.ldapPort");
            if (ldapPort == null || ldapPort.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.ldapPort set, eg: -DderbyTesting.ldapPort=333");
            }
            dnString = XAJNDITest.getSystemProperty("derbyTesting.dnString");
            if (dnString == null || dnString.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.dnString for setting o=, eg: -DderbyTesting.dnString=myJNDIstring");
            }
            return TestConfiguration.defaultSuite(XAJNDITest.class);
        }
        return new BaseTestSuite("XAJNDITest cannot run without XA support");
    }

    @Override
    public void tearDown() throws Exception {
        ldapServer = null;
        ldapPort = null;
        super.tearDown();
    }

    private InitialDirContext getInitialDirContext() {
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            String ldapContextFactory = XAJNDITest.getSystemProperty("derbyTesting.ldapContextFactory");
            if (ldapContextFactory == null || ldapContextFactory.length() < 1) {
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            } else {
                env.put("java.naming.factory.initial", ldapContextFactory);
            }
            env.put("java.naming.provider.url", "ldap://" + ldapServer + ":" + ldapPort);
            env.put("java.naming.security.authentication", "simple");
            return new InitialDirContext(env);
        }
        catch (NamingException ne) {
            XAJNDITest.fail((String)"naming exception ");
            return null;
        }
    }

    public void testCompareXADataSourcewithJNDIDataSource() throws Exception {
        XADataSource xads = J2EEDataSource.getXADataSource();
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(xads, "description", "XA DataSource");
        this.ic.rebind("cn=compareDS, o=" + dnString, (Object)xads);
        XADataSource ads = (XADataSource)this.ic.lookup("cn=compareDS, o=" + dnString);
        if (XAJNDITest.usingEmbedded()) {
            XAJNDITest.assertEquals((Object)xads, (Object)ads);
        }
        String[] orgprops = XAJNDITest.getPropertyBeanList(xads);
        String[] bindprops = XAJNDITest.getPropertyBeanList(ads);
        XAJNDITest.assertEquals((int)orgprops.length, (int)bindprops.length);
        for (int i = 0; i < orgprops.length; ++i) {
            XAJNDITest.assertEquals((String)orgprops[i], (String)bindprops[i]);
            XAJNDITest.assertEquals((Object)JDBCDataSource.getBeanProperty(xads, orgprops[i]), (Object)JDBCDataSource.getBeanProperty(ads, bindprops[i]));
        }
        JDBCDataSource.clearStringBeanProperty(xads, "createDatabase");
        XAJNDITest.assertFalse((boolean)xads.equals(ads));
    }

    private static String[] getPropertyBeanList(Object ds) {
        Method[] allMethods = ds.getClass().getMethods();
        ArrayList<CallSite> properties = new ArrayList<CallSite>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            String methodName = method.getName();
            if (methodName.length() < 5 || !methodName.startsWith("get") || method.getParameterTypes().length != 0) continue;
            Class<?> rt = method.getReturnType();
            if (rt.equals(Integer.TYPE) || rt.equals(String.class) || rt.equals(Boolean.TYPE) || rt.equals(Short.TYPE) || rt.equals(Long.TYPE)) {
                String beanName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                properties.add((CallSite)((Object)beanName));
                continue;
            }
            XAJNDITest.assertFalse((String)("Method '" + methodName + "' with primitive return type not supported - update test!!"), (boolean)rt.isPrimitive());
        }
        return properties.toArray(new String[properties.size()]);
    }
}

