/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.compatibility.AbstractCompatibilityTest;
import org.apache.derbyTesting.functionTests.tests.compatibility.helpers.DummyBlob;
import org.apache.derbyTesting.functionTests.tests.compatibility.helpers.DummyClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCDriverTest
extends AbstractCompatibilityTest {
    private static final String ALL_TYPES_TABLE = "allTypesTable";
    private static final String KEY_COLUMN = "keyCol";
    private static final byte[] SAMPLE_BYTES = new byte[]{1, 2, 3, 4, 5};
    private static final String SAMPLE_STRING = "hello";
    private static final boolean Y = true;
    private static final boolean n = false;
    private static final TypeDescriptor[] ALL_TYPES = new TypeDescriptor[]{new TypeDescriptor(-5, "bigint", DerbyVersion._10_0), new TypeDescriptor(2004, "blob", DerbyVersion._10_0), new TypeDescriptor(1, "char(5)", DerbyVersion._10_0), new TypeDescriptor(-2, "char(5) for bit data", DerbyVersion._10_0), new TypeDescriptor(2005, "clob", DerbyVersion._10_0), new TypeDescriptor(91, "date", DerbyVersion._10_0), new TypeDescriptor(3, "decimal", DerbyVersion._10_0), new TypeDescriptor(8, "double", DerbyVersion._10_0), new TypeDescriptor(8, "double precision", DerbyVersion._10_0), new TypeDescriptor(7, "float(23)", DerbyVersion._10_0), new TypeDescriptor(8, "float", DerbyVersion._10_0), new TypeDescriptor(4, "integer", DerbyVersion._10_0), new TypeDescriptor(-1, "long varchar", DerbyVersion._10_0), new TypeDescriptor(-4, "long varchar for bit data", DerbyVersion._10_0), new TypeDescriptor(2, "numeric", DerbyVersion._10_0), new TypeDescriptor(7, "real", DerbyVersion._10_0), new TypeDescriptor(5, "smallint", DerbyVersion._10_0), new TypeDescriptor(92, "time", DerbyVersion._10_0), new TypeDescriptor(93, "timestamp", DerbyVersion._10_0), new TypeDescriptor(12, "varchar(5)", DerbyVersion._10_0), new TypeDescriptor(-3, "varchar(5) for bit data", DerbyVersion._10_0)};
    private static final Object[] ROW_1 = new Object[]{1L, new DummyBlob(SAMPLE_BYTES), "hello", SAMPLE_BYTES, new DummyClob("hello"), new Date(1L), new BigDecimal(1.0), 1.0, 1.0, Float.valueOf(1.0f), 1.0, 1, "hello", SAMPLE_BYTES, new BigDecimal(1.0), Float.valueOf(1.0f), (short)1, new Time(1L), new Timestamp(1L), "hello", SAMPLE_BYTES};
    private static final T_CN[] COERCIONS = new T_CN[]{new T_CN(-5, new boolean[]{true, false, true, false, false, false, false, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(2004, new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-2, new boolean[]{false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2005, new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(91, new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(3, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(8, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(4, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(-1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-4, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(5, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(92, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}), new T_CN(93, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}), new T_CN(12, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-3, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true})};
    private static HashMap<String, TypeDescriptor> _types = new HashMap();
    private static HashMap<Integer, Integer> _coercionIndex = new HashMap();
    private static Pattern DERBY_5449_PATTERN = Pattern.compile("^10\\.8\\.([01]\\.|2\\.[012] ).*");

    public JDBCDriverTest(String name) {
        super(name);
    }

    public void testSanity() {
        JDBCDriverTest.assertEquals((String)"ALL_TYPES.length == ROW_1.length", (int)ALL_TYPES.length, (int)ROW_1.length);
        int coercionCount = COERCIONS.length;
        for (int i = 0; i < coercionCount; ++i) {
            JDBCDriverTest.assertEquals((String)("Coercion " + i), (int)coercionCount, (int)COERCIONS[i].getCoercions().length);
        }
    }

    public void testVerifyVersions() throws SQLException {
        DerbyVersion server = this.getServerVersion();
        DerbyVersion client = this.getDriverVersion();
        JDBCDriverTest.println("server=" + server.toString() + " <-> client=" + client.toString());
        String expS = JDBCDriverTest.getSystemProperty("derby.tests.compat.expectedServer");
        String expC = JDBCDriverTest.getSystemProperty("derby.tests.compat.expectedClient");
        JDBCDriverTest.assertNotNull((String)"expected server property missing", (Object)expS);
        JDBCDriverTest.assertNotNull((String)"expected client property missing", (Object)expC);
        DerbyVersion expectedServer = DerbyVersion.parseVersionString(expS);
        DerbyVersion expectedClient = DerbyVersion.parseVersionString(expC);
        JDBCDriverTest.assertEquals((String)"server version mismatch", (Object)expectedServer, (Object)server);
        JDBCDriverTest.assertEquals((String)"client version mismatch", (Object)expectedClient, (Object)client);
    }

    public void testDataTypesCompatibility() throws SQLException {
        this.datatypesTest();
    }

    public void testDerby4613(Connection conn) throws Exception {
        boolean correctBehavior = this.getServerVersion().atLeast(DerbyVersion._10_7) && this.getDriverVersion().atLeast(DerbyVersion._10_7);
        JDBCDriverTest.println("derby_4613_test correctBehavior = " + correctBehavior);
        this.vet_isindex_column(correctBehavior, "SYSTABLES_HEAP", false);
        this.vet_isindex_column(correctBehavior, "SYSTABLES_INDEX1", true);
    }

    private void vet_isindex_column(boolean correctBehavior, String conglomerateName, boolean expectedValue) throws Exception {
        String columnClassName;
        PreparedStatement ps = this.prepareStatement("select isindex from sys.sysconglomerates where conglomeratename = ?");
        ps.setString(1, conglomerateName);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        int jdbcType = correctBehavior ? 16 : 5;
        String typeName = correctBehavior ? "BOOLEAN" : "SMALLINT";
        int precision = correctBehavior ? 1 : 5;
        int scale = 0;
        int columnDisplaySize = correctBehavior ? 5 : 6;
        String string = columnClassName = correctBehavior ? "java.lang.Boolean" : "java.lang.Integer";
        Comparable<Boolean> objectValue = correctBehavior ? (Comparable<Boolean>)Boolean.valueOf(expectedValue) : (Comparable<Boolean>)Integer.valueOf(expectedValue ? 1 : 0);
        String stringValue = ((Object)objectValue).toString();
        JDBCDriverTest.assertEquals((int)jdbcType, (int)rsmd.getColumnType(1));
        JDBCDriverTest.assertEquals((String)typeName, (String)rsmd.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)precision, (int)rsmd.getPrecision(1));
        JDBCDriverTest.assertEquals((int)scale, (int)rsmd.getScale(1));
        JDBCDriverTest.assertEquals((int)columnDisplaySize, (int)rsmd.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((String)columnClassName, (String)rsmd.getColumnClassName(1));
        JDBCDriverTest.assertEquals((boolean)true, (boolean)rs.next());
        JDBCDriverTest.assertEquals((boolean)expectedValue, (boolean)rs.getBoolean(1));
        JDBCDriverTest.assertEquals((Object)objectValue, (Object)rs.getObject(1));
        JDBCDriverTest.assertEquals((String)stringValue, (String)rs.getString(1));
        rs.close();
        ps.close();
    }

    public void testDerby2602() throws SQLException {
        boolean correctBehavior = this.getServerVersion().atLeast(DerbyVersion._10_6) && this.getDriverVersion().atLeast(DerbyVersion._10_6);
        Timestamp ts = Timestamp.valueOf("2004-02-14 17:14:24.976255123");
        PreparedStatement insert = this.prepareStatement("insert into t_2602( a ) values ( ? )");
        insert.setTimestamp(1, ts);
        insert.executeUpdate();
        insert.close();
        PreparedStatement select = this.prepareStatement("select a from t_2602");
        ResultSet selectRS = select.executeQuery();
        selectRS.next();
        Timestamp resultTS = selectRS.getTimestamp(1);
        int resultNanos = resultTS.getNanos();
        int expectedResult = correctBehavior ? 976255123 : 976255000;
        JDBCDriverTest.assertEquals((int)expectedResult, (int)resultNanos);
    }

    public void testDerby4888() throws SQLException {
        JDBCDriverTest.assertFalse((boolean)this.getConnection().getMetaData().storesLowerCaseIdentifiers());
    }

    public void testDerby5449() throws SQLException {
        String driverVersion;
        if (this.getServerVersion().compareTo(DerbyVersion._10_7) <= 0 && DERBY_5449_PATTERN.matcher(driverVersion = this.getConnection().getMetaData().getDriverVersion()).matches()) {
            return;
        }
        PreparedStatement ps = this.prepareStatement("VALUES CAST(? AS INTEGER)");
        ps.setBoolean(1, true);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.setBoolean(1, false);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "0");
    }

    public void testUDT() throws Exception {
        boolean correctBehavior = this.getServerVersion().atLeast(DerbyVersion._10_6) && this.getDriverVersion().atLeast(DerbyVersion._10_6);
        String query = "select aliasinfo from sys.sysaliases";
        if (correctBehavior) {
            String aliasInfoClassName = "org.apache.derby.catalog.AliasInfo";
            this.checkRSMD(query, aliasInfoClassName, 15, 2000, aliasInfoClassName, 0, 0);
        } else {
            this.checkRSMD(query, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
        }
        if (this.serverSupportsUDTs()) {
            ByteArrayInputStream bais;
            byte[] someBytes;
            PreparedStatement ps;
            block16: {
                query = "select a from t_price";
                ps = this.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                rs.next();
                Object price = rs.getObject(1);
                String actualClassName = price.getClass().getName();
                rs.close();
                ps.close();
                if (correctBehavior) {
                    String priceClassName = "org.apache.derbyTesting.functionTests.tests.lang.Price";
                    this.checkRSMD(query, priceClassName, 15, 2000, "\"APP\".\"PRICE\"", 0, 0);
                    JDBCDriverTest.assertEquals((String)priceClassName, (String)actualClassName);
                } else {
                    this.checkRSMD(query, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                    JDBCDriverTest.assertEquals((String)"java.lang.String", (String)actualClassName);
                }
                query = "insert into t_price( a ) values ( ? )";
                if (correctBehavior) {
                    this.checkPMD(query, "org.apache.derbyTesting.functionTests.tests.lang.Price", 2000, "\"APP\".\"PRICE\"", 0, 0);
                } else {
                    this.checkPMD(query, "byte[]", -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                }
                ps = this.prepareStatement(query);
                someBytes = new byte[]{1, 2, 3};
                bais = new ByteArrayInputStream(someBytes);
                try {
                    ps.setObject(1, Price.makePrice());
                    ps.executeUpdate();
                    if (!correctBehavior) {
                        JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly worked.");
                    }
                }
                catch (SQLException se) {
                    if (!correctBehavior) break block16;
                    JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly failed.");
                }
            }
            try {
                ps.setObject(1, someBytes);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setObject( byte[] ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                ps.setBytes(1, someBytes);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setBytes( byte[] ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                ps.setBinaryStream(1, (InputStream)bais, 3);
                ps.executeUpdate();
                JDBCDriverTest.fail((String)"setBinaryStream( InputStream ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ps.close();
        }
    }

    private void checkRSMD(String query, String expectedClassName, int expectedDisplaySize, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws SQLException {
        PreparedStatement ps = this.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDriverTest.assertEquals((String)expectedClassName, (String)rsmd.getColumnClassName(1));
        JDBCDriverTest.assertEquals((int)expectedDisplaySize, (int)rsmd.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((int)expectedJDBCType, (int)rsmd.getColumnType(1));
        JDBCDriverTest.assertEquals((String)expectedSQLTypeName, (String)rsmd.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)expectedPrecision, (int)rsmd.getPrecision(1));
        JDBCDriverTest.assertEquals((int)expectedScale, (int)rsmd.getScale(1));
        rs.close();
        ps.close();
    }

    private void checkPMD(String query, String expectedClassName, int expectedJDBCType, String expectedSQLTypeName, int expectedPrecision, int expectedScale) throws SQLException {
        PreparedStatement ps = this.prepareStatement(query);
        ParameterMetaData pmd = ps.getParameterMetaData();
        JDBCDriverTest.assertEquals((String)pmd.getParameterClassName(1), (String)expectedClassName);
        JDBCDriverTest.assertEquals((int)pmd.getParameterType(1), (int)expectedJDBCType);
        JDBCDriverTest.assertEquals((String)pmd.getParameterTypeName(1), (String)expectedSQLTypeName);
        JDBCDriverTest.assertEquals((int)pmd.getPrecision(1), (int)expectedPrecision);
        JDBCDriverTest.assertEquals((int)pmd.getScale(1), (int)expectedScale);
        ps.close();
    }

    private void datatypesTest() throws SQLException {
        TypeDescriptor[] types = ALL_TYPES;
        String tableName = ALL_TYPES_TABLE;
        Object[][] rows = new Object[][]{this.makeNullRow(types.length), ROW_1};
        this.checkDBMetadata(tableName);
        this.stuffTable(tableName, types, rows);
        this.readTable(tableName, types, rows);
    }

    private void checkDBMetadata(String tableName) throws SQLException {
        String defaultUser = TestConfiguration.getCurrent().getUserName();
        String normalizedSchema = defaultUser.toUpperCase();
        String normalizedTable = tableName.toUpperCase();
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        ResultSet rs = dbmd.getColumns(null, normalizedSchema, normalizedTable, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + normalizedSchema + "." + normalizedTable);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int actualJdbcType = rs.getInt("DATA_TYPE");
            TypeDescriptor typeDesc = this.getType(columnName);
            if (columnName.equals(KEY_COLUMN)) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("[ ").append(rs.getString("COLUMN_NAME")).append(",\t").append("type( ").append(rs.getInt("DATA_TYPE")).append(" ),\t").append(rs.getString("TYPE_NAME")).append(" ]");
            JDBCDriverTest.println(builder.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)typeDesc.getJdbcType(), (int)actualJdbcType);
        }
        rs.close();
    }

    private void stuffTable(String tableName, TypeDescriptor[] types, Object[][] rows) throws SQLException {
        PreparedStatement ps = this.makeInsert(tableName, types);
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            this.setRow(ps, i + 1, types, rows[i]);
        }
        ps.close();
    }

    private PreparedStatement makeInsert(String tableName, TypeDescriptor[] types) throws SQLException {
        StringBuilder masterBuilder = new StringBuilder();
        StringBuilder columnBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        int columnNumber = 0;
        int valuesNumber = 0;
        int typeCount = types.length;
        JDBCDriverTest.beginColumnList(columnBuilder);
        JDBCDriverTest.beginColumnList(valuesBuilder);
        JDBCDriverTest.addColumn(columnBuilder, columnNumber++, JDBCDriverTest.doubleQuote(KEY_COLUMN));
        JDBCDriverTest.addColumn(valuesBuilder, valuesNumber++, "?");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = JDBCDriverTest.doubleQuote(typeName);
            JDBCDriverTest.addColumn(columnBuilder, columnNumber++, columnDesc);
            JDBCDriverTest.addColumn(valuesBuilder, valuesNumber++, "?");
        }
        JDBCDriverTest.endColumnList(columnBuilder);
        JDBCDriverTest.endColumnList(valuesBuilder);
        masterBuilder.append("insert into ").append(tableName).append("\n").append(columnBuilder.toString()).append("values\n").append(valuesBuilder.toString());
        return this.prepareStatement(masterBuilder.toString());
    }

    private void readTable(String tableName, TypeDescriptor[] types, Object[][] rows) throws SQLException {
        PreparedStatement ps = this.readTableQuery(tableName, types);
        ResultSet rs = ps.executeQuery();
        this.checkRSMD(rs);
        rs.close();
        this.checkRows(ps, types, rows);
        ps.close();
    }

    private PreparedStatement readTableQuery(String tableName, TypeDescriptor[] types) throws SQLException {
        StringBuilder builder = new StringBuilder();
        int columnNumber = 0;
        int typeCount = types.length;
        builder.append("select \n");
        JDBCDriverTest.addColumn(builder, columnNumber++, JDBCDriverTest.doubleQuote(KEY_COLUMN));
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = JDBCDriverTest.doubleQuote(typeName);
            JDBCDriverTest.addColumn(builder, columnNumber++, columnDesc);
        }
        builder.append("\nfrom ").append(tableName).append("\n").append("order by ").append(JDBCDriverTest.doubleQuote(KEY_COLUMN));
        return this.prepareStatement(builder.toString());
    }

    private void checkRSMD(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int firstTastyColumn = 0;
        JDBCDriverTest.println("ResultSetMetaData:\n");
        for (int i = ++firstTastyColumn; i < columnCount; ++i) {
            StringBuilder builder = new StringBuilder();
            int columnID = i + 1;
            String columnName = rsmd.getColumnName(columnID);
            TypeDescriptor typeDesc = this.getType(columnName);
            int expectedType = this.rsmdTypeKludge(typeDesc.getJdbcType());
            int actualType = rsmd.getColumnType(columnID);
            builder.append("[ ");
            builder.append(columnName);
            builder.append(", type( ");
            builder.append(actualType);
            builder.append(" ), ");
            builder.append(rsmd.getColumnTypeName(columnID));
            builder.append(" ]\n");
            JDBCDriverTest.println(builder.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)expectedType, (int)actualType);
        }
    }

    private void checkRows(PreparedStatement ps, TypeDescriptor[] types, Object[][] rows) throws SQLException {
        int typeCount = types.length;
        for (int colIndex = 0; colIndex < typeCount; ++colIndex) {
            TypeDescriptor type = types[colIndex];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            JDBCDriverTest.assertEquals((Object)types[colIndex], (Object)type);
            this.checkPlainGet(ps, colIndex, type, rows);
            this.checkCoercions(ps, type);
        }
    }

    private void checkPlainGet(PreparedStatement ps, int columnIndex, TypeDescriptor type, Object[][] rows) throws SQLException {
        String columnName = type.getDerbyTypeName();
        ResultSet rs = ps.executeQuery();
        for (int rowId = 0; rowId < rows.length; ++rowId) {
            JDBCDriverTest.assertTrue((String)"Not enough rows in the result", (boolean)rs.next());
            Object expectedValue = rows[rowId][columnIndex];
            Object actualValue = this.getColumn(rs, columnName, type);
            JDBCDriverTest.println("Comparing column " + columnName + ": " + expectedValue + " to " + actualValue);
            this.compareObjects(columnName, expectedValue, actualValue);
        }
        JDBCDriverTest.assertFalse((String)"Remaining rows in result", (boolean)rs.next());
        rs.close();
    }

    private void checkCoercions(PreparedStatement ps, TypeDescriptor type) throws SQLException {
        String columnName = type.getDerbyTypeName();
        T_CN coercionDesc = COERCIONS[this.getCoercionIndex(type.getJdbcType())];
        boolean[] coercions = coercionDesc.getCoercions();
        int count = coercions.length;
        int legalCoercions = 0;
        JDBCDriverTest.println("Checking coercions for " + columnName);
        for (int i = 0; i < count; ++i) {
            if (!coercions[i]) continue;
            ++legalCoercions;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int jdbcType = COERCIONS[i].getJdbcType();
                Object retval = this.getColumn(rs, columnName, jdbcType);
                JDBCDriverTest.println("\t" + jdbcType + ":\t" + retval);
            }
            rs.close();
        }
        JDBCDriverTest.println(legalCoercions + " legal coercions for " + columnName + " (type=" + type.getDerbyTypeName() + ")");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Object objval = rs.getObject(columnName);
            if (objval == null) {
                JDBCDriverTest.println("\tgetObject() = null");
                continue;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("\tgetObject() = ");
            builder.append(objval.getClass().getName());
            builder.append("( ");
            builder.append(objval);
            builder.append(" )");
            JDBCDriverTest.println(builder.toString());
        }
        rs.close();
    }

    private int rsmdTypeKludge(int originalJDbcType) {
        if (JDBCDriverTest.usingEmbedded()) {
            return originalJDbcType;
        }
        switch (originalJDbcType) {
            case 2: {
                return 3;
            }
        }
        return originalJDbcType;
    }

    private void setRow(PreparedStatement ps, int keyValue, TypeDescriptor[] types, Object[] row) throws SQLException {
        int param = 1;
        int typeCount = types.length;
        ps.setInt(param++, keyValue);
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            Object value = row[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            this.setParameter(ps, param++, type, value);
        }
        ps.execute();
    }

    private Object[] makeNullRow(int rowLength) {
        return new Object[rowLength];
    }

    private void buildTypeMap() {
        int typeCount = ALL_TYPES.length;
        for (int i = 0; i < typeCount; ++i) {
            this.putType(ALL_TYPES[i]);
        }
    }

    private void putType(TypeDescriptor type) {
        _types.put(type.getDerbyTypeName(), type);
    }

    private TypeDescriptor getType(String typeName) {
        if (_types.isEmpty()) {
            this.buildTypeMap();
        }
        return _types.get(typeName);
    }

    private void buildCoercionMap() {
        int count = COERCIONS.length;
        for (int i = 0; i < count; ++i) {
            this.putCoercionIndex(i);
        }
    }

    private void putCoercionIndex(int index) {
        _coercionIndex.put(COERCIONS[index].getJdbcType(), index);
    }

    private int getCoercionIndex(int jdbcType) {
        if (_coercionIndex.isEmpty()) {
            this.buildCoercionMap();
        }
        return _coercionIndex.get(jdbcType);
    }

    private static void createTable(Connection con, String tableName, TypeDescriptor[] types) throws SQLException {
        StringBuilder builder = new StringBuilder();
        int columnNumber = 0;
        int typeCount = types.length;
        builder.append("create table ").append(tableName).append('\n');
        JDBCDriverTest.beginColumnList(builder);
        JDBCDriverTest.addColumn(builder, columnNumber++, JDBCDriverTest.doubleQuote(KEY_COLUMN) + "\tint");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!JDBCDriverTest.getServerVersion(con).atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = JDBCDriverTest.doubleQuote(typeName) + "\t" + typeName;
            JDBCDriverTest.addColumn(builder, columnNumber++, columnDesc);
        }
        JDBCDriverTest.endColumnList(builder);
        PreparedStatement ps = con.prepareStatement(builder.toString());
        ps.execute();
        ps.close();
    }

    private static void createUDTObjects(Connection con) throws SQLException {
        if (!JDBCDriverTest.serverSupportsUDTs(con)) {
            return;
        }
        PreparedStatement ps = con.prepareStatement("create type price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        ps.execute();
        ps.close();
        ps = con.prepareStatement("create function makePrice( ) returns price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        ps.execute();
        ps.close();
        ps = con.prepareStatement("create table t_price( a price )\n");
        ps.execute();
        ps.close();
        ps = con.prepareStatement("insert into t_price( a ) values ( makePrice() )\n");
        ps.execute();
        ps.close();
    }

    private static void create_derby_2602_objects(Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement("create table t_2602( a timestamp )\n");
        ps.execute();
        ps.close();
    }

    private static void beginColumnList(StringBuilder builder) {
        builder.append("(\n");
    }

    private static void endColumnList(StringBuilder builder) {
        builder.append("\n)\n");
    }

    private static void addColumn(StringBuilder builder, int columnNumber, String text) {
        if (columnNumber > 0) {
            builder.append(",");
        }
        builder.append("\n\t");
        builder.append(text);
    }

    private void dropSchema() throws SQLException {
        this.dropTable(ALL_TYPES_TABLE);
        this.dropUDTObjects();
        this.drop_derby_2602_objects();
    }

    private void dropUDTObjects() throws SQLException {
        if (this.serverSupportsUDTs()) {
            this.dropFunction("MAKEPRICE");
            this.dropTable("T_PRICE");
            this.dropUDT("PRICE");
        }
    }

    private void drop_derby_2602_objects() throws SQLException {
        this.dropTable("T_2602");
    }

    private void setParameter(PreparedStatement ps, int param, TypeDescriptor type, Object value) throws SQLException {
        int jdbcType = type.getJdbcType();
        if (value != null) {
            this.setParameter(ps, param, jdbcType, value);
            return;
        }
        if (this.clientSupports(type)) {
            ps.setNull(param, jdbcType);
            return;
        }
        JDBCDriverTest.fail((String)("Unsupported Derby type: " + type.getDerbyTypeName()));
    }

    private boolean clientSupports(TypeDescriptor type) throws SQLException {
        DerbyVersion firstSupportedVersion = type.getDerbyVersion();
        if (firstSupportedVersion == null) {
            return false;
        }
        return this.getDriverVersion().atLeast(firstSupportedVersion);
    }

    private Object getColumn(ResultSet rs, String columnName, TypeDescriptor type) throws SQLException {
        int jdbcType = type.getJdbcType();
        return this.getColumn(rs, columnName, jdbcType);
    }

    private static String doubleQuote(String text) {
        return "\"" + text + "\"";
    }

    public static Test suite() {
        BaseTestSuite testSuite = new BaseTestSuite("JDBCDriverTest suite");
        testSuite.addTestSuite(JDBCDriverTest.class);
        return TestConfiguration.defaultExistingServerDecorator((Test)new BaseJDBCTestSetup((Test)testSuite){

            protected void setUp() throws Exception {
                super.setUp();
                Connection con = this.getConnection();
                Statement s = con.createStatement();
                ResultSet rs = s.executeQuery("values CURRENT SCHEMA");
                rs.next();
                String schema = rs.getString(1);
                rs.close();
                s.close();
                con.setAutoCommit(false);
                JDBC.dropSchema(con.getMetaData(), schema);
                con.commit();
                con.setAutoCommit(true);
                JDBCDriverTest.createTable(con, JDBCDriverTest.ALL_TYPES_TABLE, ALL_TYPES);
                JDBCDriverTest.createUDTObjects(con);
                JDBCDriverTest.create_derby_2602_objects(con);
            }
        });
    }

    public static final class TypeDescriptor {
        private int _jdbcType;
        private String _derbyTypeName;
        private DerbyVersion _derbyVersion;

        public TypeDescriptor(int jdbcType, String derbyTypeName, DerbyVersion derbyVersion) {
            this._jdbcType = jdbcType;
            this._derbyTypeName = derbyTypeName;
            this._derbyVersion = derbyVersion;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public String getDerbyTypeName() {
            return this._derbyTypeName;
        }

        public DerbyVersion getDerbyVersion() {
            return this._derbyVersion;
        }
    }

    public static final class T_CN {
        private int _jdbcType;
        private boolean[] _coercions;

        public T_CN(int jdbcType, boolean[] coercions) {
            this._jdbcType = jdbcType;
            this._coercions = coercions;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public boolean[] getCoercions() {
            return this._coercions;
        }
    }
}

