/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Bomb;
import org.apache.derbyTesting.unitTests.harness.UnitTest;
import org.apache.derbyTesting.unitTests.harness.UnitTestManager;

public class BasicUnitTestManager
implements UnitTestManager,
ModuleControl {
    private Vector<UnitTest> vectorOfTests;
    private Hashtable<String, String> namesOfTests;
    private static boolean alreadyRun = false;
    private HeaderPrintWriter output;
    private HeaderPrintWriter currentOutput;
    private int testType = 3;
    private int testDuration = 4;
    private boolean reportOutputOn = true;
    private boolean performanceReportOn = false;
    private ContextService contextService;
    private boolean runForever = false;

    public void boot(boolean bl, Properties properties) throws StandardException {
        boolean bl2 = true;
        this.output = Monitor.getStream();
        this.contextService = BasicUnitTestManager.getContextService();
        this.currentOutput = this.output;
        this.vectorOfTests = new Vector();
        this.namesOfTests = new Hashtable();
        this.findTests(properties, properties);
        this.findTests(System.getProperties(), properties);
        this.findTests(BasicUnitTestManager.getMonitor().getApplicationProperties(), properties);
        if (!alreadyRun) {
            bl2 = this.runTests();
            alreadyRun = true;
        }
        if (!bl2) {
            System.out.println("Shutting down due to unit test failure.");
            this.output.printlnWithHeader("Shutting down due to unit test failure, see log for more information.");
            BasicUnitTestManager.getMonitor().shutdown();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void registerTest(UnitTest unitTest, String string) {
        if (!this.namesOfTests.containsKey(string)) {
            this.vectorOfTests.addElement(unitTest);
            this.namesOfTests.put(string, string);
        }
    }

    private void findTests(Properties properties, Properties properties2) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("derby.module.test.")) continue;
            String string2 = properties.getProperty(string);
            try {
                Object object = BasicUnitTestManager.bootServiceModule(false, this, string2, properties2);
                if (object instanceof UnitTest) {
                    this.registerTest((UnitTest)object, string2);
                    continue;
                }
                if (object == null) continue;
                System.out.println("class does not implement UnitTest " + string2);
            }
            catch (StandardException standardException) {
                System.out.println("exception booting " + string2);
                System.out.println(standardException.toString());
                standardException.printStackTrace(System.out);
            }
        }
    }

    private void emitAMessage(String string) {
        this.currentOutput.printlnWithHeader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runATest(UnitTest unitTest) {
        boolean bl;
        String string = unitTest.getClass().getName();
        Date date = null;
        ContextManager contextManager = null;
        if (this.contextService != null) {
            contextManager = this.contextService.newContextManager();
            this.contextService.setCurrentContextManager(contextManager);
        }
        if (this.performanceReportOn) {
            date = new Date();
        }
        try {
            this.emitAMessage("Starting test  '" + string + "'.");
            bl = unitTest.Execute(this.currentOutput);
            if (bl) {
                this.emitAMessage("Test '" + string + "' passed");
            } else {
                this.emitAMessage("Test '" + string + "' failed");
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throwable.printStackTrace(this.output.getPrintWriter());
                Runtime.getRuntime().exit(1);
            }
            bl = false;
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getName();
            }
            this.emitAMessage("Test '" + string + "' failed with exception '" + string2 + "'.");
            throwable.printStackTrace(this.output.getPrintWriter());
        }
        finally {
            if (this.contextService != null) {
                this.contextService.resetCurrentContextManager(contextManager);
            }
        }
        if (this.performanceReportOn) {
            Date date2 = new Date();
            this.emitAMessage("Test '" + string + "' took " + (date2.getTime() - date.getTime()) + " milliseconds.");
        }
        return bl;
    }

    @Override
    public synchronized boolean runTests() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = true;
        if (bl2) {
            if (!this.runForever) {
                T_Bomb.makeBomb();
            }
            for (int i = this.vectorOfTests.size() - 1; i >= 0; --i) {
                UnitTest unitTest = this.vectorOfTests.elementAt(i);
                if (unitTest.UnitTestDuration() <= this.testDuration && unitTest.UnitTestType() <= this.testType) {
                    if (this.runATest(unitTest)) {
                        ++n;
                    } else {
                        ++n2;
                    }
                    this.vectorOfTests.removeElementAt(i);
                    continue;
                }
                ++n3;
            }
            this.emitAMessage("Test Summary - Run " + (n + n2) + ", Passed " + n + ", Failed " + n2 + ", Skipped " + n3 + ".");
        } else {
            this.emitAMessage("Tests not run.");
        }
        return n2 == 0;
    }

    @Override
    public boolean runTests(int n, int n2) {
        this.testType = n;
        this.testDuration = n2;
        return this.runTests();
    }

    @Override
    public void setTestDuration(int n) {
        this.testDuration = n;
    }

    @Override
    public void setTestType(int n) {
        this.testType = n;
    }

    @Override
    public void setPerformanceReportOn(boolean bl) {
        this.performanceReportOn = bl;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object bootServiceModule(boolean bl, Object object, String string, Properties properties) throws StandardException {
        try {
            return Monitor.bootServiceModule((boolean)bl, (Object)object, (String)string, (Properties)properties);
        }
        catch (Exception exception) {
            throw StandardException.plainWrapException((Throwable)exception);
        }
    }
}

