/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class BackupRestoreReEncryptTester
extends TesterObject {
    String logFile = "backup.log";
    PrintWriter logger = new PrintWriter(new FileWriter(this.logFile));

    public BackupRestoreReEncryptTester(String string) throws IOException {
        super(string);
    }

    @Override
    public void startTesting() {
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            this.log(this.getTimestamp() + " Thread " + this.getThread_id() + " starting");
            Object object = "";
            this.connex = this.getConnection();
            if (this.connex == null) {
                NsTest.logger.println("FAIL: " + this.getThread_id() + " could not get the database connection");
                return;
            }
            this.setIsolationLevel(1);
            try {
                this.doBackup();
            }
            catch (Exception exception) {
                object = this.getTimestamp() + "FAILED - BackUp thread doBackup" + this.getThread_id() + " threw " + exception;
                NsTest.logger.println((String)object);
                this.log((String)object);
                this.printException("call to doBackup() in BackupThread ", exception);
                if (NsTest.justCountErrors()) {
                    NsTest.printException(BackupRestoreReEncryptTester.class.getName(), exception);
                }
                exception.printStackTrace(NsTest.logger);
            }
            try {
                this.doRestoreandReEncrypt();
            }
            catch (SQLException sQLException) {
                if (NsTest.justCountErrors()) {
                    NsTest.printException(BackupRestoreReEncryptTester.class.getName(), sQLException);
                } else {
                    sQLException.printStackTrace(NsTest.logger);
                }
                NsTest.logger.println("FAILED at doRestoreandReEncrypt() - BackUp thread " + this.getThread_id() + " threw " + sQLException);
                this.printException("call to doRestoreandReEncrypt() in BackupThread ", sQLException);
                this.log(this.getTimestamp() + " call to doRestoreandReEncrypt() in BackupThread FAILED " + sQLException.getSQLState() + " " + sQLException);
                sQLException.printStackTrace(this.logger);
            }
            this.closeConnection();
            try {
                this.log(this.getTimestamp() + " Thread " + this.getThread_id() + " sleeping");
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                object = this.getTimestamp() + "FAILED - " + this.getThread_id() + " Sleep interrupted " + interruptedException;
                this.log((String)object);
            }
            if (NsTest.numActiveTestThreads() <= 1) {
                this.log("no more test threads, finishing backup also");
                break;
            }
            this.log("active test threads > 1, backup will continue in 10 minutes");
        }
        NsTest.logger.println("Thread " + this.getThread_id() + " is now terminating");
    }

    public void doBackup() throws SQLException {
        this.log("--------------------- B A C K U P  S E C T I O N  B E G I N ------------------------");
        CallableStatement callableStatement = this.connex.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(?, ?)");
        callableStatement.setString(1, NsTest.BACKUPDIR);
        callableStatement.setInt(2, 1);
        long l = System.currentTimeMillis();
        callableStatement.execute();
        callableStatement.close();
        long l2 = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Backup completed successfully in " + (l2 - l) / 100L + " seconds");
        try {
            String string = NsTest.getDriverURL() + NsTest.BACKUPDIR + File.separator + "nstestdb;bootPassword=12345678";
            this.doConsistCheck(string, "BACKUP");
        }
        catch (Exception exception) {
            String string = this.getTimestamp() + "FAILED - BackUp thread doConsistCheck() " + this.getThread_id() + " threw " + exception;
            this.log(string);
            this.printException("call to doConsistCheck() in BackupThread ", exception);
            exception.printStackTrace(this.logger);
        }
        this.log("--------------------- B A C K U P  S E C T I O N  E N D ----------------------------");
    }

    public void doConsistCheck(String string, String string2) throws SQLException {
        Connection connection = DriverManager.getConnection(string);
        Statement statement = connection.createStatement();
        long l = System.currentTimeMillis();
        ResultSet resultSet = statement.executeQuery("SELECT schemaname, tablename,\tSYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename)\tFROM sys.sysschemas s, sys.systables t\tWHERE s.schemaid = t.schemaid");
        while (resultSet.next()) {
            resultSet.getString(1);
            resultSet.getString(2);
            resultSet.getString(3);
        }
        long l2 = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Consistency Check on the " + string2 + " database Completed successfully " + (l2 - l) / 100L + " seconds");
        statement.close();
        connection.close();
        this.shutDownDB(string, string2);
    }

    public void doRestoreandReEncrypt() throws SQLException {
        this.log("--------------------- R E S T O R E   S E C T I O N  B E G I N ------------------------");
        String string = "RESTORED";
        Connection connection = null;
        long l = System.currentTimeMillis();
        String string2 = NsTest.getDriverURL() + NsTest.RESTOREDIR + File.separator + "nstestdb";
        String string3 = string2 + ";bootPassword=12345678;restoreFrom=" + NsTest.BACKUPDIR + File.separator + "nstestdb";
        try {
            connection = DriverManager.getConnection(string3);
            this.log(this.getTimestamp() + " Database restored successfully " + string3);
        }
        catch (SQLException sQLException) {
            this.log(this.getTimestamp() + " FAILURE ! to restore database " + string3);
            sQLException.printStackTrace(this.logger);
        }
        if (connection != null) {
            connection.close();
        }
        string3 = string2 + ";bootPassword=12345678";
        this.doConsistCheck(string3, string);
        this.log("--------------------- R E S T O R E   S E C T I O N  E N D ----------------------------");
        connection = DriverManager.getConnection(string3);
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE(?)");
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        connection.close();
        this.log(this.getTimestamp() + " Disable log archival mode to enable re-encryption " + string3);
        this.shutDownDB(string2, string);
        this.log("--------------------- ENCRYPT AND RECONNECT  S E C T I O N  BEGIN ------------------------");
        String string4 = string2 + ";dataEncryption=true;";
        string4 = string4 + ";bootPassword=12345678;newBootPassword=" + l;
        long l2 = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Encrypting database, url = " + string4);
        connection = DriverManager.getConnection(string4);
        connection.close();
        long l3 = System.currentTimeMillis();
        this.log(this.getTimestamp() + " Re-encryption completed on restored database in " + (l3 - l2) / 100L + " seconds, url = " + string4);
        string = "ENCRYPTED";
        this.shutDownDB(string2, string);
        try {
            connection = DriverManager.getConnection(string3);
            this.log(this.getTimestamp() + " FAILURE ! - Attempt to boot with old password/url should have failed, url =" + string3);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equalsIgnoreCase("XJ040") || sQLException.getSQLState().equalsIgnoreCase("XBM06")) {
                this.log(this.getTimestamp() + " PASS - Unsuccessful attempt to boot with old password/url, " + string3);
            }
            throw sQLException;
        }
        this.log("--------------------- ENCRYPT AND RECONNECT  S E C T I O N  END --------------------------");
    }

    private void shutDownDB(String object, String string) throws SQLException {
        Connection connection = null;
        object = (String)object + ";shutdown=true";
        try {
            connection = DriverManager.getConnection((String)object);
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                connection.close();
            }
            if (!sQLException.getSQLState().equalsIgnoreCase("08006")) {
                throw sQLException;
            }
            this.log(this.getTimestamp() + " " + string + " database shutdown completed, url = " + (String)object);
        }
    }

    public void log(String string) {
        this.logger.write(string + "\n");
        this.logger.flush();
        NsTest.logger.println(string);
    }
}

