/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;

public class SQLUtilities {
    public static String VALID_DATE_STRING = "'2000-01-01'";
    public static String VALID_TIME_STRING = "'15:30:20'";
    public static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    public static String NULL_VALUE = "NULL";
    public static String[] allDataTypesColumnNames = new String[]{"SMALLINTCOL", "INTEGERCOL", "BIGINTCOL", "DECIMALCOL", "REALCOL", "DOUBLECOL", "CHARCOL", "VARCHARCOL", "LONGVARCHARCOL", "CHARFORBITCOL", "VARCHARFORBITCOL", "LVARCHARFORBITCOL", "CLOBCOL", "DATECOL", "TIMECOL", "TIMESTAMPCOL", "BLOBCOL"};
    private static String[][] allDataTypesSQLData = new String[][]{{NULL_VALUE, "0", "1", "2"}, {NULL_VALUE, "0", "1", "21"}, {NULL_VALUE, "0", "1", "22"}, {NULL_VALUE, "0.0", "1.0", "23.0"}, {NULL_VALUE, "0.0", "1.0", "24.0"}, {NULL_VALUE, "0.0", "1.0", "25.0"}, {NULL_VALUE, "'0'", "'aa'", "'2.0'"}, {NULL_VALUE, "'0'", "'aa'", VALID_TIME_STRING}, {NULL_VALUE, "'0'", "'aa'", VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaaa'"}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaba'"}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaca'"}, {NULL_VALUE, "'13'", "'14'", NULL_VALUE}, {NULL_VALUE, VALID_DATE_STRING, VALID_DATE_STRING, NULL_VALUE}, {NULL_VALUE, VALID_TIME_STRING, VALID_TIME_STRING, VALID_TIME_STRING}, {NULL_VALUE, VALID_TIMESTAMP_STRING, VALID_TIMESTAMP_STRING, VALID_TIMESTAMP_STRING}, {NULL_VALUE, NULL_VALUE, NULL_VALUE, NULL_VALUE}};
    public static String[] SQLTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL(10,5)", "REAL", "DOUBLE", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "CLOB(1k)", "DATE", "TIME", "TIMESTAMP", "BLOB(1k)"};

    public static void createAndPopulateAllDataTypesTable(Statement statement) throws SQLException {
        int n;
        try {
            statement.executeUpdate("DROP TABLE AllDataTypesTable");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("create table AllDataTypesTable (");
        for (n = 0; n < SQLTypes.length - 1; ++n) {
            stringBuffer.append(allDataTypesColumnNames[n] + " " + SQLTypes[n] + ",");
        }
        stringBuffer.append(allDataTypesColumnNames[SQLTypes.length - 1] + " " + SQLTypes[SQLTypes.length - 1] + ")");
        statement.executeUpdate(stringBuffer.toString());
        for (n = 0; n < allDataTypesSQLData[0].length; ++n) {
            stringBuffer = new StringBuffer("insert into AllDataTypesTable values(");
            for (int i = 0; i < SQLTypes.length - 1; ++i) {
                stringBuffer.append(allDataTypesSQLData[i][n] + ",");
            }
            stringBuffer.append(allDataTypesSQLData[SQLTypes.length - 1][n] + ")");
            statement.executeUpdate(stringBuffer.toString());
        }
    }

    public static RuntimeStatisticsParser getRuntimeStatisticsParser(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return new RuntimeStatisticsParser(string);
    }

    public static RuntimeStatisticsParser executeAndGetRuntimeStatistics(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        Statement statement2 = connection.createStatement();
        CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        callableStatement.execute();
        callableStatement.close();
        statement.execute(string);
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBC.assertDrainResults(resultSet);
        }
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement2);
        statement.close();
        statement2.close();
        return runtimeStatisticsParser;
    }
}

