/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_5
extends UpgradeChange {
    private static final String BAD_SYNTAX = "42X01";

    public Changes10_5(String string) {
        super(string);
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.5");
        baseTestSuite.addTestSuite(Changes10_5.class);
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testUpdateStatisticsProcdure() throws SQLException {
        switch (this.getPhase()) {
            case 0: {
                Statement statement = this.createStatement();
                statement.execute("CREATE TABLE DERBY_269(c11 int, c12 char(20))");
                statement.execute("INSERT INTO DERBY_269 VALUES(1, 'DERBY-269')");
                statement.execute("CREATE INDEX I1 ON DERBY_269(c12)");
                statement.close();
                break;
            }
            case 1: 
            case 2: {
                Statement statement = this.createStatement();
                Changes10_5.assertStatementError("42Y03", statement, "call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', null)");
                Changes10_5.assertStatementError("42Y03", statement, "call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', 'I1')");
                statement.close();
                break;
            }
            case 3: {
                Statement statement = this.createStatement();
                statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', null)");
                statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'DERBY_269', 'I1')");
                statement.close();
            }
        }
    }

    public void testDeterminismKeyword() throws SQLException {
        String string = null;
        switch (this.getPhase()) {
            case 1: {
                string = "XCL47";
                break;
            }
            case 2: {
                string = BAD_SYNTAX;
                break;
            }
            case 3: {
                string = null;
                break;
            }
            default: {
                return;
            }
        }
        this.possibleError(string, "create function f_3570_12()\nreturns int\nlanguage java\nparameter style java\ndeterministic\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.possibleError(string, "create procedure p_3570_13()\nlanguage java\nnot deterministic\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
    }

    public void testGenerationClauses() throws SQLException {
        String string = null;
        switch (this.getPhase()) {
            case 1: {
                string = "XCL47";
                break;
            }
            case 2: {
                string = BAD_SYNTAX;
                break;
            }
            case 3: {
                string = null;
                break;
            }
            default: {
                return;
            }
        }
        this.possibleError(string, "create table t_genCol_2( a int, b int generated always as ( -a ), c int )");
    }

    private void possibleError(String string, String string2) throws SQLException {
        if (string != null) {
            this.assertCompileError(string, string2);
        } else {
            Statement statement = this.createStatement();
            statement.execute(string2);
            statement.close();
        }
    }

    public void testSQLRolesBasic() throws SQLException {
        Statement statement = this.createStatement();
        String string = "create role foo";
        if (this.getOldMajor() == 10 && this.getOldMinor() == 4) {
            switch (this.getPhase()) {
                case 0: {
                    Changes10_5.assertStatementError("0A000", statement, string);
                    break;
                }
                case 1: {
                    Changes10_5.assertStatementError("XCL47", statement, string);
                    break;
                }
                case 2: {
                    Changes10_5.assertStatementError("0A000", statement, string);
                    break;
                }
                case 3: {
                    Changes10_5.assertStatementError("42Z60", statement, string);
                }
            }
        } else {
            switch (this.getPhase()) {
                case 0: {
                    Changes10_5.assertStatementError(BAD_SYNTAX, statement, string);
                    break;
                }
                case 1: {
                    Changes10_5.assertStatementError("XCL47", statement, string);
                    break;
                }
                case 2: {
                    Changes10_5.assertStatementError(BAD_SYNTAX, statement, string);
                    break;
                }
                case 3: {
                    Changes10_5.assertStatementError("42Z60", statement, string);
                }
            }
        }
        statement.close();
    }

    public void testSQLRoles() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("ROLES_10_5");
        Connection connection = null;
        Statement statement = null;
        boolean bl = this.oldAtLeast(10, 2);
        JDBCDataSource.setBeanProperty(dataSource, "user", "garfield");
        JDBCDataSource.setBeanProperty(dataSource, "password", "theCat");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
                connection = dataSource.getConnection();
                CallableStatement callableStatement = connection.prepareCall("call syscs_util.syscs_set_database_property(?,?)");
                callableStatement.setString(1, "derby.connection.requireAuthentication");
                callableStatement.setString(2, "true");
                callableStatement.execute();
                callableStatement.setString(1, "derby.authentication.provider");
                callableStatement.setString(2, "BUILTIN");
                callableStatement.execute();
                callableStatement.setString(1, "derby.database.sqlAuthorization");
                callableStatement.setString(2, "true");
                callableStatement.execute();
                callableStatement.setString(1, "derby.database.propertiesOnly");
                callableStatement.setString(2, "true");
                callableStatement.execute();
                callableStatement.setString(1, "derby.user.garfield");
                callableStatement.setString(2, "theCat");
                callableStatement.execute();
                callableStatement.setString(1, "derby.user.jon");
                callableStatement.setString(2, "theOwner");
                callableStatement.execute();
                connection.close();
                JDBCDataSource.shutdownDatabase(dataSource);
                break;
            }
            case 1: {
                if (!this.oldAtLeast(10, 2)) break;
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                Changes10_5.assertStatementError("XCL47", statement, "create role foo");
                connection.close();
                JDBCDataSource.shutdownDatabase(dataSource);
                break;
            }
            case 2: {
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                if (this.getOldMajor() == 10 && this.getOldMinor() == 4) {
                    Changes10_5.assertStatementError("0A000", statement, "create role foo");
                } else {
                    Changes10_5.assertStatementError(BAD_SYNTAX, statement, "create role foo");
                }
                connection.close();
                JDBCDataSource.shutdownDatabase(dataSource);
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "upgrade=true");
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                statement.execute("create role foo");
                statement.execute("create table cats(specie varchar(30))");
                statement.execute("insert into cats values 'lynx', 'tiger', 'persian', 'garfield'");
                statement.execute("grant select on cats to foo");
                statement.execute("grant foo to jon");
                JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
                JDBCDataSource.setBeanProperty(dataSource, "user", "jon");
                JDBCDataSource.setBeanProperty(dataSource, "password", "theOwner");
                Connection connection2 = dataSource.getConnection();
                Statement statement2 = connection2.createStatement();
                Changes10_5.assertStatementError("42502", statement2, "select * from garfield.cats");
                statement2.execute("set role foo");
                statement2.execute("select * from garfield.cats");
                statement2.close();
                connection2.close();
                statement.execute("drop table cats");
                statement.execute("drop role foo");
                connection.close();
                Changes10_5.println("Roles work after hard upgrade");
                JDBCDataSource.setBeanProperty(dataSource, "user", "garfield");
                JDBCDataSource.setBeanProperty(dataSource, "password", "theCat");
                JDBCDataSource.shutdownDatabase(dataSource);
            }
        }
    }
}

