/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class Derby4923Test
extends StoreBaseTest {
    public Derby4923Test(String string) {
        super(string);
    }

    public void testDERBY_4923() throws SQLException, InterruptedException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO TESTBADUPDATE VALUES(?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("DELETE FROM TESTBADUPDATE");
        PreparedStatement preparedStatement3 = this.prepareStatement("UPDATE TESTBADUPDATE set value = ? where id = ?");
        byte[] byArray = new byte[1];
        for (n = 1000; n < 2000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
        }
        this.commit();
        preparedStatement2.executeUpdate();
        this.commit();
        this.callCompress(statement.getConnection(), "APP", "TESTBADUPDATE", true, true, false, true);
        this.commit();
        byArray = new byte[1];
        for (n = 1; n < 4; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
        }
        this.commit();
        byArray = new byte[3000];
        Arrays.fill(byArray, (byte)112);
        preparedStatement3.setBytes(1, byArray);
        preparedStatement3.setInt(2, 1);
        preparedStatement3.executeUpdate();
        this.commit();
        byArray = new byte[1500];
        Arrays.fill(byArray, (byte)112);
        preparedStatement3.setBytes(1, byArray);
        preparedStatement3.setInt(2, 2);
        preparedStatement3.executeUpdate();
        this.commit();
        byArray = new byte[4];
        Arrays.fill(byArray, (byte)112);
        preparedStatement3.setBytes(1, byArray);
        preparedStatement3.setInt(2, 2);
        preparedStatement3.executeUpdate();
        this.commit();
        byArray = new byte[3988];
        Arrays.fill(byArray, (byte)112);
        preparedStatement3.setBytes(1, byArray);
        preparedStatement3.setInt(2, 3);
        preparedStatement3.executeUpdate();
        this.commit();
        byArray = new byte[19680];
        Arrays.fill(byArray, (byte)112);
        preparedStatement3.setBytes(1, byArray);
        preparedStatement3.setInt(2, 2);
        preparedStatement3.executeUpdate();
        this.commit();
        statement.close();
        preparedStatement.close();
        preparedStatement3.close();
    }

    private void callCompress(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setInt(3, bl ? 1 : 0);
        callableStatement.setInt(4, bl2 ? 1 : 0);
        callableStatement.setInt(5, bl3 ? 1 : 0);
        callableStatement.execute();
        if (bl4) {
            connection.commit();
        }
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby4923Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
                callableStatement.execute();
                statement.executeUpdate("CREATE TABLE TESTBADUPDATE (id int, value blob(1M))");
                connection.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby4923Test");
        baseTestSuite.addTest(Derby4923Test.baseSuite("Derby4923Test:embedded"));
        return baseTestSuite;
    }
}

