/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepStmtNullTest
extends BaseJDBCTestCase {
    public PrepStmtNullTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PrepStmtNullTest");
        baseTestSuite.addTest(PrepStmtNullTest.baseSuite("PrepStmtNullTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(PrepStmtNullTest.baseSuite("PrepStmtNullTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(PrepStmtNullTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table nullTS(name varchar(10), ts timestamp)");
                statement.executeUpdate("create table nullBlob(name varchar(10), bval blob(16K))");
                statement.executeUpdate("create table ClobBlob(cval clob, bval blob(16K))");
            }
        };
    }

    public void testNullTimeStamp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into nullTS values (?,?)");
        preparedStatement.setString(1, "work");
        preparedStatement.setNull(2, 93);
        preparedStatement.addBatch();
        preparedStatement.setString(1, "work1");
        preparedStatement.setNull(2, 93, "");
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.close();
        this.commit();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from nullTS");
        String[][] stringArray = new String[][]{{"work", null}, {"work1", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.commit();
        connection.close();
    }

    public void testNullBlob() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into nullBlob values (?,?)");
        preparedStatement.setString(1, "blob");
        preparedStatement.setNull(2, 2004);
        preparedStatement.addBatch();
        preparedStatement.setString(1, "blob1");
        preparedStatement.setNull(2, 2004, "");
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.close();
        this.commit();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from nullBlob");
        String[][] stringArray = new String[][]{{"blob", null}, {"blob1", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.close();
        this.commit();
        connection.close();
    }

    public void testNullClobBlob() throws SQLException {
        byte[] byArray = new byte[]{64};
        PreparedStatement preparedStatement = this.prepareStatement("insert into ClobBlob values (?,?)");
        preparedStatement.setNull(1, 12);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.execute();
        preparedStatement.setNull(1, 12, "");
        preparedStatement.setBytes(2, byArray);
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from ClobBlob");
        String[][] stringArray = new String[][]{{null, this.bytesToString(byArray)}, {null, this.bytesToString(byArray)}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet.close();
        statement.close();
    }

    private String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }
}

